/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.filetranslations.v2.pto;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum FileType {
    DOCX("application/octet-stream", false),
    DOCM("application/octet-stream", false),
    RTF("application/octet-stream", false),
    PPTX("application/octet-stream", false),
    XLSX("application/octet-stream", false),
    IDML("application/octet-stream", false),
    RESX("application/xml", true),
    PLAIN_TEXT("text/plain", true),
    XML("application/xml", true),
    HTML("text/html", true),
    PRES("text/plain", true),
    SRT("text/plain", false),
    MARKDOWN("text/markdown", true),
    DITA("application/xml", false),
    VTT("text/vtt", true),
    FLARE("application/octet-stream", false),
    SVG("image/svg+xml", false),
    XLIFF2("application/xml", true),
    CSV("text/csv", true),
    XLSX_TEMPLATE("application/octet-stream", false),
    ANDROID("application/xml", true),
    JSON("application/json", true);

    private final String identifier = FileType.toLowerCamel(this.name());
    private final String mimeType;
    private final boolean isTextFormat;
    public static final Map<String, FileType> BY_NAME_LOOKUP;

    private static String toLowerCamel(String s) {
        StringBuilder buf = new StringBuilder();
        String[] parts = s.split("_");
        for (int i = 0; i < parts.length; ++i) {
            buf.append(i == 0 ? parts[i].toLowerCase() : StringUtils.capitalize((String)parts[i].toLowerCase()));
        }
        return buf.toString();
    }

    private FileType(String mimeType, boolean isTextFormat) {
        this.mimeType = mimeType;
        this.isTextFormat = isTextFormat;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean isTextFormat() {
        return this.isTextFormat;
    }

    public static FileType lookup(String fileTypeString) {
        return BY_NAME_LOOKUP.get(StringUtils.lowerCase((String)fileTypeString));
    }

    static {
        BY_NAME_LOOKUP = new HashMap<String, FileType>();
        for (FileType value : FileType.values()) {
            BY_NAME_LOOKUP.put(value.identifier.toLowerCase(), value);
            BY_NAME_LOOKUP.put(value.name().toLowerCase(), value);
        }
    }
}

