/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.contexts.v2;

import com.smartling.api.contexts.v2.pto.AsyncProcessPTO;
import com.smartling.api.contexts.v2.pto.AsyncProcessStartedPTO;
import com.smartling.api.contexts.v2.pto.BatchBindingPTO;
import com.smartling.api.contexts.v2.pto.BatchBindingRequestPTO;
import com.smartling.api.contexts.v2.pto.BatchDeleteBindingsRequestPTO;
import com.smartling.api.contexts.v2.pto.BindingPTO;
import com.smartling.api.contexts.v2.pto.BindingsRequestPTO;
import com.smartling.api.contexts.v2.pto.ContextPTO;
import com.smartling.api.contexts.v2.pto.ContextUploadAndMatchPTO;
import com.smartling.api.contexts.v2.pto.ContextUploadPTO;
import com.smartling.api.contexts.v2.pto.DeleteContextsAsyncRequestPTO;
import com.smartling.api.contexts.v2.pto.MatchRequestPTO;
import com.smartling.api.contexts.v2.pto.PaginatedListResponse;
import com.smartling.api.v2.response.ListResponse;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;

@Path(value="/context-api/v2")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ContextsApi {
    @POST
    @Path(value="/projects/{projectId}/contexts")
    @Consumes(value={"multipart/form-data"})
    public ContextPTO uploadContext(@PathParam(value="projectId") String var1, @MultipartForm ContextUploadPTO var2);

    @GET
    @Path(value="/projects/{projectId}/contexts")
    @Produces
    public PaginatedListResponse<ContextPTO> listContextsByProject(@PathParam(value="projectId") String var1, @QueryParam(value="nameFilter") String var2, @QueryParam(value="offset") String var3, @QueryParam(value="type") String var4);

    @GET
    @Path(value="/projects/{projectId}/contexts/{contextUid}")
    public ContextPTO getContext(@PathParam(value="projectId") String var1, @PathParam(value="contextUid") String var2);

    @DELETE
    @Path(value="/projects/{projectId}/contexts/{contextUid}")
    public void deleteContext(@PathParam(value="projectId") String var1, @PathParam(value="contextUid") String var2);

    @POST
    @Path(value="/projects/{projectId}/contexts/remove/async")
    public AsyncProcessStartedPTO deleteContextsAsync(@PathParam(value="projectId") String var1, DeleteContextsAsyncRequestPTO var2);

    @GET
    @Path(value="/projects/{projectId}/contexts/{contextUid}/content")
    public InputStream downloadContextFileContent(@PathParam(value="projectId") String var1, @PathParam(value="contextUid") String var2);

    @POST
    @Path(value="/projects/{projectId}/contexts/{contextUid}/match/async")
    public AsyncProcessStartedPTO matchAsync(@PathParam(value="projectId") String var1, @PathParam(value="contextUid") String var2, MatchRequestPTO var3);

    @POST
    @Path(value="/projects/{projectId}/contexts/upload-and-match-async")
    @Consumes(value={"multipart/form-data"})
    public AsyncProcessStartedPTO uploadContextAndMatchAsync(@PathParam(value="projectId") String var1, @MultipartForm ContextUploadAndMatchPTO var2);

    @GET
    @Path(value="/projects/{projectId}/processes/{processUid}")
    public AsyncProcessPTO getAsyncProcess(@PathParam(value="projectId") String var1, @PathParam(value="processUid") String var2);

    @POST
    @Path(value="/projects/{projectId}/bindings")
    @Produces
    public BatchBindingPTO createBindings(@PathParam(value="projectId") String var1, BindingsRequestPTO var2);

    @POST
    @Path(value="/projects/{projectId}/bindings/list")
    @Produces
    public PaginatedListResponse<BindingPTO> listBindings(@PathParam(value="projectId") String var1, BatchBindingRequestPTO var2, @QueryParam(value="offset") String var3);

    @POST
    @Path(value="/projects/{projectId}/bindings/remove")
    @Produces
    public ListResponse<BindingPTO> deleteBindings(@PathParam(value="projectId") String var1, BatchDeleteBindingsRequestPTO var2);
}

