/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smartling.api.v2.client.CloseClientInvocationHandler;
import com.smartling.api.v2.client.ExceptionDecoratorInvocationHandler;
import com.smartling.api.v2.client.HttpClientConfiguration;
import com.smartling.api.v2.client.auth.AuthorizationRequestFilter;
import com.smartling.api.v2.client.exception.DefaultRestApiExceptionMapper;
import com.smartling.api.v2.client.exception.RestApiExceptionHandler;
import com.smartling.api.v2.client.exception.RestApiExceptionMapper;
import com.smartling.api.v2.client.unmarshal.DetailsDeserializer;
import com.smartling.api.v2.client.unmarshal.RestApiContextResolver;
import com.smartling.api.v2.client.unmarshal.RestApiResponseReaderInterceptor;
import com.smartling.api.v2.response.Details;
import com.smartling.resteasy.ext.ExtendedMultipartFormWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ReaderInterceptor;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ClientFactory {
    protected static boolean containsAuthFilter(List<ClientRequestFilter> clientRequestFilters) {
        if (clientRequestFilters == null) {
            return false;
        }
        for (ClientRequestFilter filter : clientRequestFilters) {
            if (!(filter instanceof AuthorizationRequestFilter)) continue;
            return true;
        }
        return false;
    }

    private ConnectionSocketFactory getSslConnectionSocketFactory(HttpClientConfiguration configuration) {
        SSLContext sslContext = configuration.getSslContext() != null ? configuration.getSslContext() : SSLContexts.createDefault();
        return new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
    }

    protected HttpClientConnectionManager getHttpClientConnectionManager(HttpClientConfiguration configuration) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)this.getSslConnectionSocketFactory(configuration)).build());
        connectionManager.setDefaultMaxPerRoute(configuration.getMaxThreadPerRoute());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoKeepAlive(true).build());
        connectionManager.setMaxTotal(configuration.getMaxThreadTotal());
        return connectionManager;
    }

    protected RequestConfig getRequestConfig(HttpClientConfiguration configuration) {
        return RequestConfig.custom().setSocketTimeout(configuration.getSocketTimeout()).setConnectTimeout(configuration.getConnectionTimeout()).setConnectionRequestTimeout(configuration.getConnectionRequestTimeout()).setStaleConnectionCheckEnabled(configuration.isStaleConnectionCheckEnabled()).build();
    }

    protected HttpClientBuilder getHttpClientBuilder(HttpClientConfiguration configuration) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(this.getRequestConfig(configuration)).setConnectionManager(this.getHttpClientConnectionManager(configuration));
        if (configuration.getProxyHost() != null && configuration.getProxyPort() != null) {
            HttpHost proxyHost = new HttpHost(configuration.getProxyHost(), configuration.getProxyPort().intValue());
            httpClientBuilder.setProxy(proxyHost);
            if (configuration.getProxyUser() != null && configuration.getProxyPassword() != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(configuration.getProxyUser(), configuration.getProxyPassword()));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return httpClientBuilder;
    }

    protected ClientHttpEngine getClientHttpEngine(HttpClientConfiguration configuration) {
        HttpClientBuilder httpClientBuilder = this.getHttpClientBuilder(configuration);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return new ApacheHttpClient43Engine((HttpClient)httpClient, true);
    }

    protected Map<Class<?>, JsonDeserializer<?>> getDeserializerMap() {
        HashMap classJsonDeserializerMap = new HashMap();
        classJsonDeserializerMap.put(Details.class, new DetailsDeserializer());
        return classJsonDeserializerMap;
    }

    protected Map<Class<?>, JsonSerializer<?>> getSerializerMap() {
        return Collections.emptyMap();
    }

    protected ContextResolver<ObjectMapper> getObjectMapperContextResolver(Map<Class<?>, JsonDeserializer<?>> classJsonDeserializerMap, Map<Class<?>, JsonSerializer<?>> classJsonSerializerMap) {
        return new RestApiContextResolver(classJsonDeserializerMap, classJsonSerializerMap);
    }

    protected ReaderInterceptor getRestApiResponseReaderInterceptor() {
        return new RestApiResponseReaderInterceptor();
    }

    public <T> T build(List<ClientRequestFilter> clientRequestFilters, List<ClientResponseFilter> clientResponseFilters, String domain, Class<T> klass) {
        return this.build(clientRequestFilters, clientResponseFilters, domain, klass, new HttpClientConfiguration(), null, null);
    }

    <T> T build(List<ClientRequestFilter> clientRequestFilters, List<ClientResponseFilter> clientResponseFilters, String domain, Class<T> klass, HttpClientConfiguration configuration, ResteasyProviderFactory providerFactory, RestApiExceptionMapper exceptionMapper) {
        Objects.requireNonNull(clientRequestFilters, "clientRequestFilters must be defined");
        Objects.requireNonNull(clientResponseFilters, "clientResponseFilters must be defined");
        Objects.requireNonNull(domain, "domain must be defined");
        Objects.requireNonNull(klass, "klass must be defined");
        Objects.requireNonNull(this.getDeserializerMap(), "deserializerMap must be defined");
        Objects.requireNonNull(configuration, "configuration must be defined");
        if (!ClientFactory.containsAuthFilter(clientRequestFilters)) {
            throw new IllegalArgumentException("At least one request filter is required for authorization");
        }
        ResteasyClientBuilder builder = (ResteasyClientBuilder)ClientBuilder.newBuilder();
        builder.httpEngine(this.getClientHttpEngine(configuration));
        if (providerFactory != null) {
            builder.providerFactory(providerFactory);
        }
        ContextResolver<ObjectMapper> contextResolver = this.getObjectMapperContextResolver(this.getDeserializerMap(), this.getSerializerMap());
        ResteasyWebTarget client = builder.build().target(domain).register((Object)this.getRestApiResponseReaderInterceptor()).register((Object)new ExtendedMultipartFormWriter()).register(contextResolver);
        for (ClientRequestFilter clientRequestFilter : clientRequestFilters) {
            client.register((Object)clientRequestFilter);
        }
        for (ClientResponseFilter clientResponseFilter : clientResponseFilters) {
            client.register((Object)clientResponseFilter);
        }
        Object proxy = client.proxy(klass);
        RestApiExceptionHandler restApiExceptionHandler = new RestApiExceptionHandler(exceptionMapper != null ? exceptionMapper : new DefaultRestApiExceptionMapper());
        ExceptionDecoratorInvocationHandler<Object> handler = new ExceptionDecoratorInvocationHandler<Object>(proxy, restApiExceptionHandler);
        CloseClientInvocationHandler closeClientInvocationHandler = new CloseClientInvocationHandler(handler, (Client)client.getResteasyClient());
        return (T)Proxy.newProxyInstance(klass.getClassLoader(), new Class[]{klass}, (InvocationHandler)closeClientInvocationHandler);
    }
}

