/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.smartling.api.v2.client.ClientFactory;
import com.smartling.api.v2.client.HttpClientConfiguration;
import com.smartling.api.v2.client.auth.AbstractBearerAuthFilter;
import com.smartling.api.v2.client.auth.BearerAuthSecretFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public abstract class AbstractApiFactory<T> {
    private static final String DEFAULT_API_HOST = "api.smartling.com";
    protected static final String DEFAULT_API_HOST_AND_PROTOCOL = "https://api.smartling.com";
    private final ClientFactory clientFactory;

    public AbstractApiFactory() {
        this(new ClientFactory());
    }

    protected AbstractApiFactory(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected abstract Class<T> getApiClass();

    protected List<ClientResponseFilter> getClientResponseFilters() {
        return Collections.emptyList();
    }

    protected Map<Class<?>, JsonDeserializer<?>> getDeserializerMap() {
        return this.clientFactory.getDefaultDeserializerMap();
    }

    protected HttpClientConfiguration getHttpClientConfiguration() {
        return new HttpClientConfiguration();
    }

    public T buildApi(String userIdentifier, String userSecret) {
        Objects.requireNonNull(userIdentifier, "userIdentifier must be defined");
        Objects.requireNonNull(userSecret, "userSecret must be defined");
        BearerAuthSecretFilter bearerAuthSecretFilter = new BearerAuthSecretFilter(userIdentifier, userSecret, DEFAULT_API_HOST_AND_PROTOCOL);
        return this.buildApi(bearerAuthSecretFilter);
    }

    public T buildApi(AbstractBearerAuthFilter authFilter) {
        return this.buildApi(authFilter, DEFAULT_API_HOST_AND_PROTOCOL);
    }

    public T buildApi(AbstractBearerAuthFilter authFilter, String hostAndProtocol) {
        Objects.requireNonNull(authFilter, "authFilter must be defined");
        LinkedList<ClientRequestFilter> filters = new LinkedList<ClientRequestFilter>();
        filters.add(authFilter);
        return this.buildApi(filters, hostAndProtocol);
    }

    public T buildApi(List<ClientRequestFilter> filterList, String hostAndProtocol) {
        return this.buildApi(filterList, hostAndProtocol, this.getHttpClientConfiguration());
    }

    public T buildApi(List<ClientRequestFilter> filterList, String hostAndProtocol, HttpClientConfiguration httpClientConfiguration) {
        Objects.requireNonNull(filterList, "filterList must be defined");
        Objects.requireNonNull(hostAndProtocol, "hostAndProtocol must be defined");
        Objects.requireNonNull(httpClientConfiguration, "httpClientConfiguration must be defined");
        return this.clientFactory.build(filterList, this.getClientResponseFilters(), hostAndProtocol, this.getApiClass(), this.getDeserializerMap(), httpClientConfiguration, null);
    }

    public T buildApi(List<ClientRequestFilter> filterList, String hostAndProtocol, ResteasyProviderFactory providerFactory) {
        Objects.requireNonNull(filterList, "filterList must be defined");
        Objects.requireNonNull(hostAndProtocol, "hostAndProtocol must be defined");
        return this.clientFactory.build(filterList, this.getClientResponseFilters(), hostAndProtocol, this.getApiClass(), this.getDeserializerMap(), this.getHttpClientConfiguration(), providerFactory);
    }

    public T buildApi(List<ClientRequestFilter> filterList, String hostAndProtocol, HttpClientConfiguration httpClientConfiguration, ResteasyProviderFactory providerFactory) {
        Objects.requireNonNull(filterList, "filterList must be defined");
        Objects.requireNonNull(hostAndProtocol, "hostAndProtocol must be defined");
        Objects.requireNonNull(httpClientConfiguration, "httpClientConfiguration must be defined");
        return this.clientFactory.build(filterList, this.getClientResponseFilters(), hostAndProtocol, this.getApiClass(), this.getDeserializerMap(), httpClientConfiguration, providerFactory);
    }
}

