/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client.unmarshal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
public class RestApiContextResolver
implements ContextResolver<ObjectMapper> {
    private ObjectMapper objectMapper;

    public RestApiContextResolver(Map<Class<?>, JsonDeserializer<?>> classJsonDeserializerMap) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule deserializerModule = new SimpleModule();
        for (Class<?> klass : classJsonDeserializerMap.keySet()) {
            deserializerModule.addDeserializer(klass, classJsonDeserializerMap.get(klass));
        }
        objectMapper.registerModule((Module)deserializerModule);
        this.objectMapper = objectMapper;
    }

    public ObjectMapper getContext(Class<?> type) {
        return this.objectMapper;
    }
}

