/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client;

import java.util.Objects;

public class HttpClientConfiguration {
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 60000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int MAX_THREAD_PER_ROUTE = 20;
    public static final int MAX_THREAD_TOTAL = 20;
    private int connectionRequestTimeout = 60000;
    private int connectionTimeout = 10000;
    private int maxThreadPerRoute = 20;
    private int maxThreadTotal = 20;
    private int socketTimeout = 10000;
    private boolean staleConnectionCheckEnabled = true;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public HttpClientConfiguration setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public HttpClientConfiguration setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getMaxThreadPerRoute() {
        return this.maxThreadPerRoute;
    }

    public HttpClientConfiguration setMaxThreadPerRoute(int maxThreadPerRoute) {
        this.maxThreadPerRoute = maxThreadPerRoute;
        return this;
    }

    public int getMaxThreadTotal() {
        return this.maxThreadTotal;
    }

    public HttpClientConfiguration setMaxThreadTotal(int maxThreadTotal) {
        this.maxThreadTotal = maxThreadTotal;
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public HttpClientConfiguration setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public boolean isStaleConnectionCheckEnabled() {
        return this.staleConnectionCheckEnabled;
    }

    public HttpClientConfiguration setStaleConnectionCheckEnabled(boolean staleConnectionCheckEnabled) {
        this.staleConnectionCheckEnabled = staleConnectionCheckEnabled;
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public HttpClientConfiguration setProxyHost(String proxyHost) {
        this.proxyHost = Objects.requireNonNull(proxyHost, "Proxy host must not be empty");
        return this;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public HttpClientConfiguration setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public HttpClientConfiguration setProxyUser(String proxyUser) {
        this.proxyUser = Objects.requireNonNull(proxyUser, "Proxy user must not be empty");
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public HttpClientConfiguration setProxyPassword(String proxyPassword) {
        this.proxyPassword = Objects.requireNonNull(proxyPassword, "Proxy password must not be empty");
        return this;
    }
}

