/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.api.v2.client.unmarshal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.smartling.api.v2.response.EmptyData;
import com.smartling.api.v2.response.Response;
import com.smartling.api.v2.response.RestApiResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeader;

@Provider
@Priority(value=5000)
public class RestApiResponseReaderInterceptor
implements ReaderInterceptor {
    protected static final EmptyData EMPTY_DATA = new EmptyData();

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        if (!"application/json".equalsIgnoreCase(this.getResponseContentType(context))) {
            return context.proceed();
        }
        if (RestApiResponse.class.isAssignableFrom(context.getType())) {
            return context.proceed();
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode requestNode = mapper.readTree(context.getInputStream());
        JsonNode node = requestNode.get("response");
        if (!Response.class.isAssignableFrom(context.getType())) {
            node = node.get("data");
        }
        if (node.isNull() && EmptyData.class.isAssignableFrom(context.getType())) {
            return EMPTY_DATA;
        }
        context.setInputStream((InputStream)new ByteArrayInputStream(node.toString().getBytes(StandardCharsets.UTF_8)));
        return context.proceed();
    }

    private String getResponseContentType(ReaderInterceptorContext context) {
        BasicHeader header;
        HeaderElement[] helems;
        List contentTypeHeaders;
        String contentType = null;
        List list = contentTypeHeaders = context.getHeaders() == null ? null : (List)context.getHeaders().get((Object)"Content-Type");
        if (contentTypeHeaders != null && !contentTypeHeaders.isEmpty() && (helems = (header = new BasicHeader("Content-Type", (String)contentTypeHeaders.get(0))).getElements()).length > 0) {
            contentType = helems[0].getName();
        }
        return contentType;
    }
}

