/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay.hapiclient.http.auth;

import com.slimpay.hapiclient.exception.HttpException;
import com.slimpay.hapiclient.http.HapiClient;
import com.slimpay.hapiclient.http.Method;
import com.slimpay.hapiclient.http.Request;
import com.slimpay.hapiclient.http.UrlEncodedBody;
import com.slimpay.hapiclient.http.auth.AuthenticationMethod;
import com.slimpay.hapiclient.http.auth.ExpirableToken;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.json.JsonObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;

public final class Oauth2BasicAuthentication
implements AuthenticationMethod {
    private final String tokenEndPointUrl;
    private final String userid;
    private final String password;
    private final String grantType;
    private final String scope;
    private ExpirableToken token;

    private Oauth2BasicAuthentication(String tokenEndPointUrl, String userid, String password, String grantType, String scope, ExpirableToken token) {
        this.tokenEndPointUrl = tokenEndPointUrl;
        this.userid = userid;
        this.password = password;
        this.grantType = grantType;
        this.scope = scope;
    }

    public String getTokenEndPointUrl() {
        return this.tokenEndPointUrl;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public synchronized ExpirableToken getToken() {
        return this.token;
    }

    public synchronized void authorizeRequest(HapiClient hapiClient, HttpUriRequest httpRequest) throws HttpException {
        if (this.isRequestAuthorized(httpRequest)) {
            return;
        }
        if (!this.isTokenStillValid()) {
            this.getAccessToken(hapiClient);
        }
        httpRequest.removeHeaders("Authorization");
        httpRequest.addHeader("Authorization", "Bearer " + this.token.getValue());
    }

    private boolean isRequestAuthorized(HttpUriRequest httpRequest) {
        Header authorization = httpRequest.getFirstHeader("Authorization");
        if (authorization == null) {
            return false;
        }
        return authorization.getValue().startsWith("Basic") || authorization.getValue().startsWith("Bearer");
    }

    private synchronized void getAccessToken(HapiClient hapiClient) throws HttpException {
        String basic = new String(Base64.encodeBase64((byte[])(String.valueOf(this.userid) + ":" + this.password).getBytes()));
        BasicHeader acceptHeader = new BasicHeader("Accept", "application/json");
        BasicHeader authorizationHeader = new BasicHeader("Authorization", "Basic " + basic);
        UrlEncodedBody requestData = new UrlEncodedBody();
        requestData.put("grant_type", this.grantType);
        requestData.put("scope", this.scope);
        Request request = new Request.Builder(this.tokenEndPointUrl).setMethod(Method.POST).setMessageBody(requestData).addHeader((Header)acceptHeader).addHeader((Header)authorizationHeader).build();
        JsonObject state = hapiClient.send(request).getState();
        if (state == null || !state.containsKey((Object)"access_token") || !state.containsKey((Object)"expires_in")) {
            throw new RuntimeException("The authentication was a success but the response did not contain the token or its validity limit.");
        }
        this.token = new ExpirableToken(state.getString("access_token"), this.getTime() + Long.valueOf(state.getInt("expires_in")));
    }

    private synchronized boolean isTokenStillValid() {
        return this.token != null && this.token.isValidUntil(this.getTime());
    }

    private Long getTime() {
        return TimeUnit.MILLISECONDS.toSeconds(new Date().getTime());
    }

    /* synthetic */ Oauth2BasicAuthentication(String string, String string2, String string3, String string4, String string5, ExpirableToken expirableToken, Oauth2BasicAuthentication oauth2BasicAuthentication) {
        this(string, string2, string3, string4, string5, expirableToken);
    }

    public static class Builder {
        private String tokenEndPointUrl;
        private String userid;
        private String password;
        private String grantType = "client_credentials";
        private String scope = "api";
        private ExpirableToken token;

        public Builder setTokenEndPointUrl(String tokenEndPointUrl) {
            this.tokenEndPointUrl = tokenEndPointUrl;
            return this;
        }

        public Builder setUserid(String userid) {
            this.userid = userid;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setGrantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder setScope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder setToken(ExpirableToken token) {
            this.token = token;
            return this;
        }

        public Oauth2BasicAuthentication build() {
            return new Oauth2BasicAuthentication(this.tokenEndPointUrl, this.userid, this.password, this.grantType, this.scope, this.token, null);
        }
    }
}

