/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay.hapiclient.http;

import com.slimpay.hapiclient.http.MessageBody;
import com.slimpay.hapiclient.http.Method;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractRequest {
    protected final Method method;
    protected final Map<String, Object> urlVariables;
    protected final HttpEntity messageBody;
    protected final List<Header> headers;

    protected AbstractRequest(Method method, Map<String, Object> urlVariables, HttpEntity messageBody, List<Header> headers) {
        this.method = method;
        this.urlVariables = AbstractRequest.unmodifiableUrlVariables(urlVariables);
        this.messageBody = messageBody;
        this.headers = Collections.unmodifiableList(headers);
    }

    private static Map<String, Object> unmodifiableUrlVariables(Map<String, Object> urlVariables) {
        for (String key : urlVariables.keySet()) {
            Object value = urlVariables.get(key);
            if (value instanceof Map) {
                value = Collections.unmodifiableMap((Map)value);
            } else if (value instanceof List) {
                value = Collections.unmodifiableList((List)value);
            } else if (value.getClass().isArray()) {
                value = value instanceof Object[] ? Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(value))) : AbstractRequest.unmodifiablePrimitiveArray(value);
            }
            urlVariables.put(key, value);
        }
        return Collections.unmodifiableMap(urlVariables);
    }

    private static List<Object> unmodifiablePrimitiveArray(Object array) {
        ArrayList<Serializable> list;
        if (array instanceof int[]) {
            list = new ArrayList<Serializable>(((int[])array).length);
            int[] nArray = (int[])array;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int val = nArray[n2];
                list.add(Integer.valueOf(val));
                ++n2;
            }
        } else if (array instanceof double[]) {
            list = new ArrayList(((double[])array).length);
            double[] dArray = (double[])array;
            int n = dArray.length;
            int n3 = 0;
            while (n3 < n) {
                double val = dArray[n3];
                list.add(Double.valueOf(val));
                ++n3;
            }
        } else if (array instanceof char[]) {
            list = new ArrayList(((char[])array).length);
            char[] cArray = (char[])array;
            int n = cArray.length;
            int n4 = 0;
            while (n4 < n) {
                char val = cArray[n4];
                list.add(Character.valueOf(val));
                ++n4;
            }
        } else if (array instanceof float[]) {
            list = new ArrayList(((float[])array).length);
            float[] fArray = (float[])array;
            int n = fArray.length;
            int n5 = 0;
            while (n5 < n) {
                float val = fArray[n5];
                list.add(Float.valueOf(val));
                ++n5;
            }
        } else if (array instanceof boolean[]) {
            list = new ArrayList(((boolean[])array).length);
            boolean[] blArray = (boolean[])array;
            int n = blArray.length;
            int n6 = 0;
            while (n6 < n) {
                boolean val = blArray[n6];
                list.add(Boolean.valueOf(val));
                ++n6;
            }
        } else if (array instanceof short[]) {
            list = new ArrayList(((short[])array).length);
            short[] sArray = (short[])array;
            int n = sArray.length;
            int n7 = 0;
            while (n7 < n) {
                short val = sArray[n7];
                list.add(Short.valueOf(val));
                ++n7;
            }
        } else if (array instanceof long[]) {
            list = new ArrayList(((long[])array).length);
            long[] lArray = (long[])array;
            int n = lArray.length;
            int n8 = 0;
            while (n8 < n) {
                long val = lArray[n8];
                list.add(Long.valueOf(val));
                ++n8;
            }
        } else if (array instanceof byte[]) {
            list = new ArrayList(((byte[])array).length);
            byte[] byArray = (byte[])array;
            int n = byArray.length;
            int n9 = 0;
            while (n9 < n) {
                byte val = byArray[n9];
                list.add(Byte.valueOf(val));
                ++n9;
            }
        } else {
            throw new IllegalArgumentException("The 'array' given is not an array of primitives.");
        }
        return Collections.unmodifiableList(list);
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<String, Object> getUrlVariables() {
        return this.urlVariables;
    }

    public HttpEntity getMessageBody() {
        return this.messageBody;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Builder {
        protected Method method = Method.GET;
        protected final Map<String, Object> urlVariables = new HashMap<String, Object>();
        protected HttpEntity messageBody;
        protected final List<Header> headers = new ArrayList<Header>();

        protected Builder() {
        }

        public Builder setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Builder setUrlVariables(Map<String, Object> urlVariables) {
            if (urlVariables != null && !urlVariables.isEmpty()) {
                this.urlVariables.putAll(urlVariables);
            }
            return this;
        }

        public Builder setUrlVariable(String variableName, Object value) {
            this.urlVariables.put(variableName, value);
            return this;
        }

        public Builder setMessageBody(HttpEntity messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public Builder setMessageBody(MessageBody messageBody) {
            this.messageBody = messageBody.getHttpEntity();
            return this;
        }

        public Builder addHeader(Header header) {
            this.headers.add(header);
            return this;
        }

        public Builder addHeaders(List<Header> headers) {
            if (headers != null) {
                this.headers.addAll(headers);
            }
            return this;
        }

        public abstract AbstractRequest build();
    }
}

