/*
 * Decompiled with CFR 0.152.
 */
package com.slimpay.hapiclient.exception;

import com.slimpay.hapiclient.hal.Resource;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class HttpException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final HttpRequestBase request;
    private final CloseableHttpResponse response;
    private final String responseBody;

    public HttpException(HttpRequestBase request, CloseableHttpResponse response, String responseBody) {
        super(String.valueOf(String.valueOf(response.getStatusLine().getStatusCode())) + " " + response.getStatusLine().getReasonPhrase());
        this.request = request;
        this.response = response;
        this.responseBody = responseBody;
    }

    public HttpRequestBase getRequest() {
        return this.request;
    }

    public CloseableHttpResponse getResponse() {
        return this.response;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public int getStatusCode() {
        return this.getResponse().getStatusLine().getStatusCode();
    }

    public String getReasonPhrase() {
        return this.getResponse().getStatusLine().getReasonPhrase();
    }

    public Resource getResponseResource() {
        return this.responseBody != null ? Resource.fromJson(this.responseBody) : null;
    }
}

