/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.latch.LatchException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class LatchTable {
    private Map<Thread, Set<Object>> latchesByThread = Collections.synchronizedMap(new WeakHashMap());

    LatchTable() {
    }

    boolean noteLatch(Object latch) throws LatchException {
        Thread cur = Thread.currentThread();
        Set<Object> threadLatches = this.latchesByThread.get(cur);
        if (threadLatches == null) {
            threadLatches = new HashSet<Object>();
            this.latchesByThread.put(cur, threadLatches);
        }
        threadLatches.add(latch);
        return true;
    }

    boolean unNoteLatch(Object latch, String name) {
        Thread cur = Thread.currentThread();
        Set<Object> threadLatches = this.latchesByThread.get(cur);
        if (threadLatches == null) {
            return false;
        }
        return threadLatches.remove(latch);
    }

    int countLatchesHeld() {
        Thread cur = Thread.currentThread();
        Set<Object> threadLatches = this.latchesByThread.get(cur);
        if (threadLatches != null) {
            return threadLatches.size();
        }
        return 0;
    }

    String latchesHeldToString() {
        Thread cur = Thread.currentThread();
        Set<Object> threadLatches = this.latchesByThread.get(cur);
        StringBuilder sb = new StringBuilder();
        if (threadLatches != null) {
            Iterator<Object> i = threadLatches.iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append('\n');
            }
        }
        return sb.toString();
    }

    void clearNotes() {
        this.latchesByThread.clear();
    }
}

