/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.app_backend.slash_commands;

import com.slack.api.app_backend.slash_commands.payload.SlashCommandPayload;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlashCommandPayloadParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlashCommandPayloadParser.class);

    public SlashCommandPayload parse(String requestBody) {
        String[] pairs;
        if (requestBody == null) {
            return null;
        }
        SlashCommandPayload payload = new SlashCommandPayload();
        for (String pair : pairs = requestBody.split("\\&")) {
            String[] fields = pair.split("=");
            if (fields.length != 2) continue;
            try {
                String name = URLDecoder.decode(fields[0].trim().replaceAll("\\n+", ""), "UTF-8");
                String value = URLDecoder.decode(fields[1], "UTF-8");
                switch (name) {
                    case "token": {
                        payload.setToken(value);
                        break;
                    }
                    case "team_id": {
                        payload.setTeamId(value);
                        break;
                    }
                    case "team_domain": {
                        payload.setTeamDomain(value);
                        break;
                    }
                    case "enterprise_id": {
                        payload.setEnterpriseId(value);
                        break;
                    }
                    case "enterprise_name": {
                        payload.setEnterpriseName(value);
                        break;
                    }
                    case "api_app_id": {
                        payload.setApiAppId(value);
                        break;
                    }
                    case "channel_id": {
                        payload.setChannelId(value);
                        break;
                    }
                    case "channel_name": {
                        payload.setChannelName(value);
                        break;
                    }
                    case "user_id": {
                        payload.setUserId(value);
                        break;
                    }
                    case "user_name": {
                        payload.setUserName(value);
                        break;
                    }
                    case "command": {
                        payload.setCommand(value);
                        break;
                    }
                    case "text": {
                        payload.setText(value);
                        break;
                    }
                    case "response_url": {
                        payload.setResponseUrl(value);
                        break;
                    }
                    case "trigger_id": {
                        payload.setTriggerId(value);
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error("Failed to decode URL-encoded string values - {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return payload;
    }
}

