/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.app_backend.vendor.aws.lambda.response;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiGatewayResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiGatewayResponse.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final int statusCode;
    private final String body;
    private final Map<String, String> headers;
    private final boolean isBase64Encoded;

    public ApiGatewayResponse(int statusCode, String body, Map<String, String> headers, boolean isBase64Encoded) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
        this.isBase64Encoded = isBase64Encoded;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isIsBase64Encoded() {
        return this.isBase64Encoded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ApiGatewayResponse build302Response(String location) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Location", location);
        return ApiGatewayResponse.builder().statusCode(302).headers(headers).build();
    }

    public static class Builder {
        private int statusCode = 200;
        private Map<String, String> headers = Collections.emptyMap();
        private String rawBody;
        private Object objectBody;
        private byte[] binaryBody;
        private boolean base64Encoded;

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder rawBody(String rawBody) {
            this.rawBody = rawBody;
            return this;
        }

        public Builder objectBody(Object objectBody) {
            this.objectBody = objectBody;
            return this;
        }

        public Builder binaryBody(byte[] binaryBody) {
            this.binaryBody = binaryBody;
            this.base64Encoded(true);
            return this;
        }

        public Builder base64Encoded(boolean base64Encoded) {
            this.base64Encoded = base64Encoded;
            return this;
        }

        public ApiGatewayResponse build() {
            String body = null;
            if (this.rawBody != null) {
                body = this.rawBody;
            } else if (this.objectBody != null) {
                body = GSON.toJson(this.objectBody);
            } else if (this.binaryBody != null) {
                body = new String(Base64.getEncoder().encode(this.binaryBody), StandardCharsets.UTF_8);
            }
            log.debug("body: {}", (Object)body);
            return new ApiGatewayResponse(this.statusCode, body, this.headers, this.base64Encoded);
        }
    }
}

