/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.app_backend.ssl_check;

import com.slack.api.app_backend.ssl_check.payload.SSLCheckPayload;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCheckPayloadParser {
    private static final Logger log = LoggerFactory.getLogger(SSLCheckPayloadParser.class);

    public SSLCheckPayload parse(String requestBody) {
        String[] pairs;
        if (requestBody == null) {
            return null;
        }
        SSLCheckPayload payload = new SSLCheckPayload();
        for (String pair : pairs = requestBody.split("\\&")) {
            String[] fields = pair.split("=");
            if (fields.length != 2) continue;
            try {
                String name = URLDecoder.decode(fields[0].trim().replaceAll("\\n+", ""), "UTF-8");
                String value = URLDecoder.decode(fields[1], "UTF-8");
                switch (name) {
                    case "token": {
                        payload.setToken(value);
                        break;
                    }
                    case "ssl_check": {
                        payload.setSslCheck(value);
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error("Failed to decode URL-encoded string values - {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return payload;
    }
}

