/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class UnknownPropertyDetectionAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        if (delegate instanceof ReflectiveTypeAdapterFactory.Adapter) {
            try {
                Class<?> adaptorClass = delegate.getClass();
                Field boundFieldsField = null;
                while (boundFieldsField == null && !adaptorClass.equals(Object.class)) {
                    try {
                        boundFieldsField = adaptorClass.getDeclaredField("boundFields");
                    }
                    catch (NoSuchFieldException _ignore) {
                        adaptorClass = adaptorClass.getSuperclass();
                    }
                }
                if (boundFieldsField == null) {
                    String message = "Failed to find bound fields inside GSON";
                    throw new IllegalStateException(message);
                }
                boundFieldsField.setAccessible(true);
                Map boundFields = (Map)boundFieldsField.get(delegate);
                StringBuilder sb = new StringBuilder();
                for (Object key : boundFields.keySet()) {
                    sb.append(key + ", ");
                }
                final String boundFieldsStr = sb.append("...").toString();
                boundFields = new LinkedHashMap(boundFields){

                    @Override
                    public Object get(Object key) {
                        Object value = super.get(key);
                        if (value == null) {
                            throw new JsonParseException("Unknown property detected: " + key + " in " + boundFieldsStr);
                        }
                        return value;
                    }
                };
                boundFieldsField.set(delegate, boundFields);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return delegate;
    }
}

