/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.block.UnknownBlockElement;
import com.slack.api.model.block.element.BlockElement;
import com.slack.api.model.block.element.ButtonElement;
import com.slack.api.model.block.element.ChannelsSelectElement;
import com.slack.api.model.block.element.CheckboxesElement;
import com.slack.api.model.block.element.ConversationsSelectElement;
import com.slack.api.model.block.element.DatePickerElement;
import com.slack.api.model.block.element.DatetimePickerElement;
import com.slack.api.model.block.element.EmailTextInputElement;
import com.slack.api.model.block.element.ExternalSelectElement;
import com.slack.api.model.block.element.ImageElement;
import com.slack.api.model.block.element.MultiChannelsSelectElement;
import com.slack.api.model.block.element.MultiConversationsSelectElement;
import com.slack.api.model.block.element.MultiExternalSelectElement;
import com.slack.api.model.block.element.MultiStaticSelectElement;
import com.slack.api.model.block.element.MultiUsersSelectElement;
import com.slack.api.model.block.element.NumberInputElement;
import com.slack.api.model.block.element.OverflowMenuElement;
import com.slack.api.model.block.element.PlainTextInputElement;
import com.slack.api.model.block.element.RadioButtonsElement;
import com.slack.api.model.block.element.RichTextInputElement;
import com.slack.api.model.block.element.RichTextListElement;
import com.slack.api.model.block.element.RichTextPreformattedElement;
import com.slack.api.model.block.element.RichTextQuoteElement;
import com.slack.api.model.block.element.RichTextSectionElement;
import com.slack.api.model.block.element.StaticSelectElement;
import com.slack.api.model.block.element.TimePickerElement;
import com.slack.api.model.block.element.URLTextInputElement;
import com.slack.api.model.block.element.UsersSelectElement;
import com.slack.api.model.block.element.WorkflowButtonElement;
import java.lang.reflect.Type;

public class GsonBlockElementFactory
implements JsonDeserializer<BlockElement>,
JsonSerializer<BlockElement> {
    private boolean failOnUnknownProperties;

    public GsonBlockElementFactory() {
        this(false);
    }

    public GsonBlockElementFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    public BlockElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonPrimitive prim = (JsonPrimitive)jsonObject.get("type");
        String typeName = prim.getAsString();
        Class<? extends BlockElement> clazz = this.getContextBlockElementClassInstance(typeName);
        return (BlockElement)context.deserialize((JsonElement)jsonObject, clazz);
    }

    public JsonElement serialize(BlockElement src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    private Class<? extends BlockElement> getContextBlockElementClassInstance(String typeName) {
        switch (typeName) {
            case "button": {
                return ButtonElement.class;
            }
            case "image": {
                return ImageElement.class;
            }
            case "channels_select": {
                return ChannelsSelectElement.class;
            }
            case "users_select": {
                return UsersSelectElement.class;
            }
            case "external_select": {
                return ExternalSelectElement.class;
            }
            case "conversations_select": {
                return ConversationsSelectElement.class;
            }
            case "static_select": {
                return StaticSelectElement.class;
            }
            case "multi_channels_select": {
                return MultiChannelsSelectElement.class;
            }
            case "multi_users_select": {
                return MultiUsersSelectElement.class;
            }
            case "multi_external_select": {
                return MultiExternalSelectElement.class;
            }
            case "multi_conversations_select": {
                return MultiConversationsSelectElement.class;
            }
            case "multi_static_select": {
                return MultiStaticSelectElement.class;
            }
            case "overflow": {
                return OverflowMenuElement.class;
            }
            case "datepicker": {
                return DatePickerElement.class;
            }
            case "timepicker": {
                return TimePickerElement.class;
            }
            case "datetimepicker": {
                return DatetimePickerElement.class;
            }
            case "plain_text_input": {
                return PlainTextInputElement.class;
            }
            case "rich_text_input": {
                return RichTextInputElement.class;
            }
            case "url_text_input": {
                return URLTextInputElement.class;
            }
            case "email_text_input": {
                return EmailTextInputElement.class;
            }
            case "number_input": {
                return NumberInputElement.class;
            }
            case "rich_text_section": {
                return RichTextSectionElement.class;
            }
            case "rich_text_list": {
                return RichTextListElement.class;
            }
            case "rich_text_quote": {
                return RichTextQuoteElement.class;
            }
            case "rich_text_preformatted": {
                return RichTextPreformattedElement.class;
            }
            case "radio_buttons": {
                return RadioButtonsElement.class;
            }
            case "checkboxes": {
                return CheckboxesElement.class;
            }
            case "workflow_button": {
                return WorkflowButtonElement.class;
            }
        }
        if (this.failOnUnknownProperties) {
            throw new JsonParseException("Unknown block element type: " + typeName);
        }
        return UnknownBlockElement.class;
    }
}

