/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.audit.impl;

import com.slack.api.audit.AuditApiResponse;
import com.slack.api.audit.AuditConfig;
import com.slack.api.audit.impl.AsyncAuditRateLimiter;
import com.slack.api.audit.impl.AsyncExecutionSupplier;
import com.slack.api.rate_limits.WaitTime;
import com.slack.api.rate_limits.queue.QueueMessage;
import com.slack.api.rate_limits.queue.RateLimitQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRateLimitQueue
extends RateLimitQueue<AsyncExecutionSupplier<? extends AuditApiResponse>, AuditMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncRateLimitQueue.class);
    private static final ConcurrentMap<String, ConcurrentMap<String, AsyncRateLimitQueue>> ALL_QUEUES = new ConcurrentHashMap<String, ConcurrentMap<String, AsyncRateLimitQueue>>();
    private AsyncAuditRateLimiter rateLimiter;
    private final ConcurrentMap<String, LinkedBlockingQueue<AuditMessage>> methodNameToActiveQueue = new ConcurrentHashMap<String, LinkedBlockingQueue<AuditMessage>>();

    private static ConcurrentMap<String, AsyncRateLimitQueue> getInstance(String executorName) {
        ConcurrentHashMap teamIdToQueue = (ConcurrentHashMap)ALL_QUEUES.get(executorName);
        if (teamIdToQueue == null) {
            teamIdToQueue = new ConcurrentHashMap();
            ALL_QUEUES.put(executorName, teamIdToQueue);
        }
        return teamIdToQueue;
    }

    @Override
    public AsyncAuditRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(AsyncAuditRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    private AsyncRateLimitQueue(AuditConfig config) {
        this.rateLimiter = new AsyncAuditRateLimiter(config);
    }

    public static AsyncRateLimitQueue get(String executorName, String teamId) {
        if (executorName == null || teamId == null) {
            throw new IllegalArgumentException("`executorName` and `teamId` are required");
        }
        ConcurrentMap<String, AsyncRateLimitQueue> teamIdToQueue = AsyncRateLimitQueue.getInstance(executorName);
        return (AsyncRateLimitQueue)teamIdToQueue.get(teamId);
    }

    public static AsyncRateLimitQueue getOrCreate(AuditConfig config, String teamId) {
        if (teamId == null) {
            throw new IllegalArgumentException("`teamId` is required");
        }
        ConcurrentMap<String, AsyncRateLimitQueue> teamIdToQueue = AsyncRateLimitQueue.getInstance(config.getExecutorName());
        AsyncRateLimitQueue queue = (AsyncRateLimitQueue)teamIdToQueue.get(teamId);
        if (queue != null && queue.getRateLimiter().getMetricsDatastore() != config.getMetricsDatastore()) {
            queue.setRateLimiter(new AsyncAuditRateLimiter(config));
        }
        if (queue == null) {
            queue = new AsyncRateLimitQueue(config);
            teamIdToQueue.put(teamId, queue);
        }
        return queue;
    }

    @Override
    protected AuditMessage buildNewMessage(String messageId, long epochMillisToRun, WaitTime waitTime, AsyncExecutionSupplier<? extends AuditApiResponse> methodsSupplier) {
        return new AuditMessage(messageId, epochMillisToRun, waitTime, methodsSupplier);
    }

    public static class AuditMessage
    extends QueueMessage<AsyncExecutionSupplier> {
        private String id;
        private long millisToRun;
        private WaitTime waitTime;
        private AsyncExecutionSupplier<?> supplier;

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public long getMillisToRun() {
            return this.millisToRun;
        }

        @Override
        @Generated
        public WaitTime getWaitTime() {
            return this.waitTime;
        }

        @Override
        @Generated
        public AsyncExecutionSupplier<?> getSupplier() {
            return this.supplier;
        }

        @Override
        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Override
        @Generated
        public void setMillisToRun(long millisToRun) {
            this.millisToRun = millisToRun;
        }

        @Override
        @Generated
        public void setWaitTime(WaitTime waitTime) {
            this.waitTime = waitTime;
        }

        @Override
        @Generated
        public void setSupplier(AsyncExecutionSupplier<?> supplier) {
            this.supplier = supplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuditMessage)) {
                return false;
            }
            AuditMessage other = (AuditMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMillisToRun() != other.getMillisToRun()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            WaitTime this$waitTime = this.getWaitTime();
            WaitTime other$waitTime = other.getWaitTime();
            if (this$waitTime == null ? other$waitTime != null : !((Object)this$waitTime).equals(other$waitTime)) {
                return false;
            }
            Object this$supplier = this.getSupplier();
            Object other$supplier = other.getSupplier();
            return !(this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuditMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $millisToRun = this.getMillisToRun();
            result = result * 59 + (int)($millisToRun >>> 32 ^ $millisToRun);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            WaitTime $waitTime = this.getWaitTime();
            result = result * 59 + ($waitTime == null ? 43 : ((Object)$waitTime).hashCode());
            Object $supplier = this.getSupplier();
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AsyncRateLimitQueue.AuditMessage(id=" + this.getId() + ", millisToRun=" + this.getMillisToRun() + ", waitTime=" + this.getWaitTime() + ", supplier=" + this.getSupplier() + ")";
        }

        @Generated
        public AuditMessage(String id, long millisToRun, WaitTime waitTime, AsyncExecutionSupplier<?> supplier) {
            this.id = id;
            this.millisToRun = millisToRun;
            this.waitTime = waitTime;
            this.supplier = supplier;
        }
    }
}

