/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.status.v2.impl;

import com.google.gson.reflect.TypeToken;
import com.slack.api.status.v2.StatusApiException;
import com.slack.api.status.v2.StatusClient;
import com.slack.api.status.v2.model.CurrentStatus;
import com.slack.api.status.v2.model.SlackIssue;
import com.slack.api.util.http.SlackHttpClient;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

public class StatusClientImpl
implements StatusClient {
    private String endpointUrlPrefix = "https://slack-status.com/api/v2.0.0/";
    private final SlackHttpClient slackHttpClient;

    public StatusClientImpl(SlackHttpClient slackHttpClient) {
        this.slackHttpClient = slackHttpClient;
    }

    @Override
    public String getEndpointUrlPrefix() {
        return this.endpointUrlPrefix;
    }

    @Override
    public void setEndpointUrlPrefix(String endpointUrlPrefix) {
        this.endpointUrlPrefix = endpointUrlPrefix;
    }

    @Override
    public CurrentStatus current() throws IOException, StatusApiException {
        Response response = this.slackHttpClient.get(this.endpointUrlPrefix + "current", null, null);
        String body = response.body().string();
        this.slackHttpClient.runHttpResponseListeners(response, body);
        if (response.isSuccessful()) {
            return (CurrentStatus)GsonFactory.createSnakeCase(this.slackHttpClient.getConfig()).fromJson(body, CurrentStatus.class);
        }
        throw new StatusApiException(response, body);
    }

    @Override
    public List<SlackIssue> history() throws IOException, StatusApiException {
        Response response = this.slackHttpClient.get(this.endpointUrlPrefix + "history", null, null);
        Type listType = new TypeToken<ArrayList<SlackIssue>>(){}.getType();
        String body = response.body().string();
        this.slackHttpClient.runHttpResponseListeners(response, body);
        if (response.isSuccessful()) {
            return (List)GsonFactory.createSnakeCase(this.slackHttpClient.getConfig()).fromJson(body, listType);
        }
        throw new StatusApiException(response, body);
    }
}

