/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.http;

import com.google.gson.Gson;
import com.slack.api.SlackConfig;
import com.slack.api.util.http.UserAgentInterceptor;
import com.slack.api.util.http.listener.HttpResponseListener;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackHttpClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackHttpClient.class);
    private final OkHttpClient okHttpClient;
    private SlackConfig config = SlackConfig.DEFAULT;

    public SlackHttpClient(Map<String, String> userAgentCustomInfo) {
        this.okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new UserAgentInterceptor(userAgentCustomInfo)).build();
    }

    public SlackHttpClient() {
        this(Collections.emptyMap());
    }

    public SlackHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public void close() throws Exception {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        if (this.okHttpClient.cache() != null) {
            this.okHttpClient.cache().close();
        }
    }

    public SlackConfig getConfig() {
        return this.config;
    }

    public void setConfig(SlackConfig config) {
        this.config = config;
    }

    public Response get(String url, Map<String, String> query, String token) throws IOException {
        Request request;
        if (query != null) {
            HttpUrl.Builder u = HttpUrl.parse((String)url).newBuilder();
            for (Map.Entry<String, String> each : query.entrySet()) {
                u = u.addQueryParameter(each.getKey(), each.getValue());
            }
            url = u.build().toString();
        }
        if (token != null) {
            String bearerHeaderValue = "Bearer " + token;
            request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).get().build();
        } else {
            request = new Request.Builder().url(url).get().build();
        }
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postMultipart(String url, String token, MultipartBody multipartBody) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).post((RequestBody)multipartBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postForm(String url, FormBody formBody) throws IOException {
        Request request = new Request.Builder().url(url).post((RequestBody)formBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postFormWithBearerHeader(String url, String token, FormBody formBody) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        return this.postFormWithAuthorizationHeader(url, bearerHeaderValue, formBody);
    }

    public Response postFormWithAuthorizationHeader(String url, String authorizationHeader, FormBody formBody) throws IOException {
        Request request = new Request.Builder().url(url).header("Authorization", authorizationHeader).post((RequestBody)formBody).build();
        return this.okHttpClient.newCall(request).execute();
    }

    @Deprecated
    public Response postJsonPostRequest(String url, Object obj) throws IOException {
        return this.postJsonBody(url, obj);
    }

    public Response postJsonBody(String url, Object obj) throws IOException {
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.toSnakeCaseJsonString(obj));
        Request request = new Request.Builder().url(url).post(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postJsonBodyWithBearerHeader(String url, String token, Object obj) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.toSnakeCaseJsonString(obj));
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).post(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response patchJsonBodyWithBearerHeader(String url, String token, Object obj) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.toSnakeCaseJsonString(obj));
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).patch(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response putJsonBodyWithBearerHeader(String url, String token, Object obj) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.toSnakeCaseJsonString(obj));
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).put(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response postCamelCaseJsonBodyWithBearerHeader(String url, String token, Object obj) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.toCamelCaseJsonString(obj));
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).post(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response patchCamelCaseJsonBodyWithBearerHeader(String url, String token, Object obj) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.toCamelCaseJsonString(obj));
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).patch(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response putCamelCaseJsonBodyWithBearerHeader(String url, String token, Object obj) throws IOException {
        String bearerHeaderValue = "Bearer " + token;
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.toCamelCaseJsonString(obj));
        Request request = new Request.Builder().url(url).header("Authorization", bearerHeaderValue).put(body).build();
        return this.okHttpClient.newCall(request).execute();
    }

    public Response delete(Request.Builder requestBuilder) throws IOException {
        return this.okHttpClient.newCall(requestBuilder.method("DELETE", null).build()).execute();
    }

    private String toSnakeCaseJsonString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        Gson gson = GsonFactory.createSnakeCase(this.config);
        return gson.toJson(obj);
    }

    private String toCamelCaseJsonString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        Gson gson = GsonFactory.createCamelCase(this.config);
        return gson.toJson(obj);
    }

    public void runHttpResponseListeners(Response response, String body) {
        HttpResponseListener.State state = new HttpResponseListener.State(this.config, response, body);
        for (HttpResponseListener responseListener : this.config.getHttpClientResponseHandlers()) {
            responseListener.accept(state);
        }
    }
}

