/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.impl;

import com.slack.api.methods.MethodsConfig;
import com.slack.api.methods.MethodsRateLimitTier;
import com.slack.api.methods.MethodsRateLimits;
import com.slack.api.methods.metrics.LastMinuteRequests;
import com.slack.api.methods.metrics.MetricsDatastore;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMethodsRateLimiter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncMethodsRateLimiter.class);
    private final MethodsConfig config;
    private final MetricsDatastore metricsDatastore;

    public MetricsDatastore getMetricsDatastore() {
        return this.metricsDatastore;
    }

    public AsyncMethodsRateLimiter(MethodsConfig config) {
        this.config = config;
        this.metricsDatastore = config.getMetricsDatastore();
    }

    public WaitTime acquireWaitTime(String teamId, String methodName) {
        return this.calculateWaitTime(teamId, methodName);
    }

    public WaitTime acquireWaitTimeForChatPostMessage(String teamId, String channelId) {
        return this.calculateWaitTime(teamId, "chat.postMessage", "_" + channelId);
    }

    private WaitTime calculateWaitTime(String teamId, String methodName) {
        return this.calculateWaitTime(teamId, methodName, "");
    }

    private WaitTime calculateWaitTime(String teamId, String methodName, String suffix) {
        Long retryAfterEpochMillis;
        String key = methodName + suffix;
        MethodsRateLimitTier tier = MethodsRateLimits.lookupRateLimitTier(methodName);
        int allowedRequests = this.getAllowedRequestsPerMinute(tier);
        if (log.isDebugEnabled()) {
            int currentRequests = this.getNumberOfLastMinuteRequests(teamId, key);
            log.debug("current requests: {}, allowed requests: {}", (Object)currentRequests, (Object)allowedRequests);
        }
        if ((retryAfterEpochMillis = this.metricsDatastore.getRateLimitedMethodRetryEpochMillis(this.config.getExecutorName(), teamId, methodName)) != null) {
            long waitMillis = retryAfterEpochMillis - System.currentTimeMillis();
            WaitTime currentSituation = this.calculateWaitTime(teamId, key, allowedRequests);
            long additionalMillis = currentSituation.getMillisToWait();
            if (currentSituation.getPace() == Pace.Burst) {
                additionalMillis *= 7L;
            } else if (currentSituation.getPace() == Pace.TooFastPaced) {
                additionalMillis *= 5L;
            }
            return new WaitTime(waitMillis + additionalMillis, Pace.RateLimited);
        }
        return this.calculateWaitTime(teamId, key, allowedRequests);
    }

    private WaitTime calculateWaitTime(String teamId, String key, int allowedRequests) {
        LastMinuteRequests lastMinuteRequests = this.metricsDatastore.getLastMinuteRequests(this.config.getExecutorName(), teamId, key);
        if (this.isBurst(lastMinuteRequests, allowedRequests)) {
            if (log.isDebugEnabled()) {
                log.debug("Burst requests detected (method: {}, last minute requests: {}, allowed: {})", new Object[]{key, lastMinuteRequests.size(), allowedRequests});
            }
            Double waitMillis = 180000.0 / (double)allowedRequests;
            return new WaitTime(waitMillis.longValue(), Pace.Burst);
        }
        if (AsyncMethodsRateLimiter.isTooFastPaced(lastMinuteRequests, allowedRequests)) {
            Double waitMillis = 120000.0 / (double)allowedRequests;
            return new WaitTime(waitMillis.longValue(), Pace.TooFastPaced);
        }
        if (AsyncMethodsRateLimiter.isOptimalPace(lastMinuteRequests, allowedRequests)) {
            Double waitMillis = 60000.0 / (double)allowedRequests;
            return new WaitTime(waitMillis.longValue(), Pace.Optimal);
        }
        if (AsyncMethodsRateLimiter.isSomewhatBusy(lastMinuteRequests, allowedRequests)) {
            Double waitMillis = 30000.0 / (double)allowedRequests;
            return new WaitTime(waitMillis.longValue(), Pace.Safe);
        }
        return new WaitTime(0L, Pace.Safe);
    }

    private boolean isBurst(LastMinuteRequests lastMinuteRequests, int allowedRequests) {
        if (lastMinuteRequests.size() > allowedRequests / 10) {
            long threeSecondsAgo = System.currentTimeMillis() - 3000L;
            long burstRequests = lastMinuteRequests.stream().filter(millis -> millis > threeSecondsAgo).count();
            return burstRequests >= (long)(allowedRequests / 10);
        }
        return false;
    }

    private static boolean isSomewhatBusy(LastMinuteRequests lastMinuteRequests, int allowedRequests) {
        int currentSize = lastMinuteRequests.size();
        return (double)currentSize >= (double)allowedRequests * 0.3 && (double)currentSize < (double)allowedRequests * 0.6;
    }

    private static boolean isOptimalPace(LastMinuteRequests lastMinuteRequests, int allowedRequests) {
        int currentSize = lastMinuteRequests.size();
        return (double)currentSize >= (double)allowedRequests * 0.6 && (double)currentSize < (double)allowedRequests * 0.9;
    }

    private static boolean isTooFastPaced(LastMinuteRequests lastMinuteRequests, int allowedRequests) {
        return (double)lastMinuteRequests.size() >= (double)allowedRequests * 0.9;
    }

    private Integer getAllowedRequestsPerMinute(MethodsRateLimitTier tier) {
        Integer allowedRequestsForOneNode = MethodsRateLimitTier.getAllowedRequestsPerMinute(tier);
        return allowedRequestsForOneNode / this.metricsDatastore.getNumberOfNodes();
    }

    private Integer getNumberOfLastMinuteRequests(String teamId, String methodNameWithSuffix) {
        return this.metricsDatastore.getNumberOfLastMinuteRequests(this.config.getExecutorName(), teamId, methodNameWithSuffix);
    }

    static enum Pace {
        RateLimited,
        Safe,
        Optimal,
        TooFastPaced,
        Burst;

    }

    static class WaitTime {
        private long millisToWait;
        private Pace pace;

        @Generated
        public long getMillisToWait() {
            return this.millisToWait;
        }

        @Generated
        public Pace getPace() {
            return this.pace;
        }

        @Generated
        public void setMillisToWait(long millisToWait) {
            this.millisToWait = millisToWait;
        }

        @Generated
        public void setPace(Pace pace) {
            this.pace = pace;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WaitTime)) {
                return false;
            }
            WaitTime other = (WaitTime)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMillisToWait() != other.getMillisToWait()) {
                return false;
            }
            Pace this$pace = this.getPace();
            Pace other$pace = other.getPace();
            return !(this$pace == null ? other$pace != null : !((Object)((Object)this$pace)).equals((Object)other$pace));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WaitTime;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $millisToWait = this.getMillisToWait();
            result = result * 59 + (int)($millisToWait >>> 32 ^ $millisToWait);
            Pace $pace = this.getPace();
            result = result * 59 + ($pace == null ? 43 : ((Object)((Object)$pace)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AsyncMethodsRateLimiter.WaitTime(millisToWait=" + this.getMillisToWait() + ", pace=" + (Object)((Object)this.getPace()) + ")";
        }

        @Generated
        public WaitTime(long millisToWait, Pace pace) {
            this.millisToWait = millisToWait;
            this.pace = pace;
        }
    }
}

