/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin.oauth.view.default_impl;

import com.slack.api.bolt.model.Installer;
import com.slack.api.bolt.service.builtin.oauth.view.OAuthRedirectUriPageRenderer;

public class OAuthDefaultRedirectUriPageRenderer
implements OAuthRedirectUriPageRenderer {
    public static final String SUCCESS_PAGE_TEMPLATE = "<html>\n<head>\n<meta http-equiv=\"refresh\" content=\"0; URL=__URL__\">\n<style>\nbody {\n  padding: 10px 15px;\n  font-family: verdana;\n  text-align: center;\n}\n</style>\n</head>\n<body>\n<h2>Thank you!</h2>\n<p>Redirecting to the Slack App... click <a href=\"__URL__\">here</a></p>\n</body>\n</html>";
    public static final String FAILURE_PAGE_TEMPLATE = "<html>\n<head>\n<style>\nbody {\n  padding: 10px 15px;\n  font-family: verdana;\n  text-align: center;\n}\n</style>\n</head>\n<body>\n<h2>Oops, Something Went Wrong!</h2>\n<p>Please try again from <a href=\"__INSTALL_PATH__\">here</a> or contact the app owner (reason: __REASON__)</p>\n</body>\n</html>";

    @Override
    public String renderSuccessPage(Installer installer, String completionUrl) {
        String url = completionUrl;
        if (url == null || url.isEmpty()) {
            if (installer.getIsEnterpriseInstall() != null && installer.getIsEnterpriseInstall().booleanValue() && installer.getEnterpriseUrl() != null && installer.getAppId() != null) {
                String rootUrl = installer.getEnterpriseUrl();
                url = rootUrl + "manage/organization/apps/profile/" + installer.getAppId() + "/workspaces/add";
            } else {
                url = installer.getTeamId() == null || installer.getAppId() == null ? "slack://open" : "slack://app?team=" + installer.getTeamId() + "&id=" + installer.getAppId();
            }
        }
        return SUCCESS_PAGE_TEMPLATE.replaceAll("__URL__", url == null ? "" : url);
    }

    @Override
    public String renderFailurePage(String installPath, String reason) {
        return FAILURE_PAGE_TEMPLATE.replaceAll("__INSTALL_PATH__", installPath == null ? "" : installPath).replaceAll("__REASON__", reason == null ? "unknown_error" : reason);
    }
}

