/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.interactive_components.payload.BlockSuggestionPayload;
import com.slack.api.bolt.context.builtin.BlockSuggestionContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class BlockSuggestionRequest
extends Request<BlockSuggestionContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final BlockSuggestionPayload payload;
    private BlockSuggestionContext context = new BlockSuggestionContext();

    public BlockSuggestionRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (BlockSuggestionPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, BlockSuggestionPayload.class);
        if (this.payload.getEnterprise() != null) {
            this.getContext().setEnterpriseId(this.payload.getEnterprise().getId());
        } else if (this.payload.getTeam() != null) {
            this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        }
        if (this.payload.getTeam() != null) {
            this.getContext().setTeamId(this.payload.getTeam().getId());
        }
        this.getContext().setRequestUserId(this.payload.getUser().getId());
    }

    @Override
    public BlockSuggestionContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.BlockSuggestion;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public BlockSuggestionPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getResponseUrl() {
        return null;
    }

    @Override
    @Generated
    public String toString() {
        return "BlockSuggestionRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

