/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.service.builtin;

import com.slack.api.bolt.Initializer;
import com.slack.api.bolt.service.OAuthStateService;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

public class AmazonS3OAuthStateService
implements OAuthStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AmazonS3OAuthStateService.class);
    private final String bucketName;
    private AwsCredentialsProvider credentialsProvider;

    public AmazonS3OAuthStateService(String bucketName) {
        this.bucketName = bucketName;
    }

    @Override
    public Initializer initializer() {
        return app -> {
            this.credentialsProvider = DefaultCredentialsProvider.create();
            AwsCredentials credentials = this.createCredentials(this.credentialsProvider);
            if (credentials == null || credentials.accessKeyId() == null) {
                throw new IllegalStateException("AWS credentials not found");
            }
            if (log.isDebugEnabled()) {
                log.debug("AWS credentials loaded (access key id: {})", (Object)credentials.accessKeyId());
            }
            boolean bucketExists = false;
            Exception ex = null;
            try (S3Client s3 = this.createS3Client();){
                bucketExists = s3.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucketName).build()) != null;
            }
            catch (Exception e) {
                ex = e;
            }
            if (!bucketExists) {
                String error = ex != null ? ex.getClass().getName() + ":" + ex.getMessage() : "-";
                String message = "Failed to access the Amazon S3 bucket (name: " + this.bucketName + ", error: " + error + ")";
                throw new IllegalStateException(message);
            }
        };
    }

    @Override
    public void addNewStateToDatastore(String state) throws Exception {
        PutObjectResponse putObjectResult;
        try (S3Client s3 = this.createS3Client();){
            String value = "" + (System.currentTimeMillis() + this.getExpirationInSeconds() * 1000L);
            putObjectResult = s3.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(this.getKey(state)).build(), RequestBody.fromString((String)value));
        }
        if (log.isDebugEnabled()) {
            log.debug("AWS S3 putObject result of state data - {}", (Object)putObjectResult.toString());
        }
    }

    @Override
    public boolean isAvailableInDatabase(String state) {
        S3Client s3 = this.createS3Client();
        ResponseBytes<GetObjectResponse> s3Object = this.getObject(s3, this.getKey(state));
        if (s3Object == null) {
            return false;
        }
        String millisToExpire = null;
        try {
            millisToExpire = s3Object.asString(StandardCharsets.UTF_8);
            return Long.parseLong(millisToExpire) > System.currentTimeMillis();
        }
        catch (NumberFormatException ne) {
            log.error("Invalid state value detected - state: {}, millisToExpire: {}", (Object)state, (Object)millisToExpire);
            return false;
        }
        catch (Exception e) {
            log.error("Failed to load a state data for state: {}", (Object)state, (Object)e);
            return false;
        }
    }

    @Override
    public void deleteStateFromDatastore(String state) throws Exception {
        try (S3Client s3 = this.createS3Client();){
            s3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName).key(this.getKey(state)).build());
        }
    }

    protected AwsCredentials createCredentials(AwsCredentialsProvider provider) {
        return provider.resolveCredentials();
    }

    protected S3Client createS3Client() {
        return (S3Client)((S3ClientBuilder)S3Client.builder().credentialsProvider(this.credentialsProvider)).build();
    }

    private String getKey(String state) {
        return "state/" + state;
    }

    private ResponseBytes<GetObjectResponse> getObject(S3Client s3, String fullKey) {
        try {
            return (ResponseBytes)s3.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(fullKey).build(), ResponseTransformer.toBytes());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Amazon S3 object metadata not found (key: {}, Exception: {})", (Object)fullKey, (Object)e.toString());
            }
            return null;
        }
    }
}

