/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware.builtin;

import com.slack.api.RequestConfigurator;
import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.app_backend.slash_commands.response.SlashCommandResponse;
import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.middleware.Middleware;
import com.slack.api.bolt.middleware.MiddlewareChain;
import com.slack.api.bolt.middleware.MiddlewareOps;
import com.slack.api.bolt.model.Bot;
import com.slack.api.bolt.model.Installer;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.service.InstallationService;
import com.slack.api.bolt.util.Responder;
import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.auth.AuthTestResponse;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.token_rotation.RefreshedToken;
import com.slack.api.token_rotation.TokenRotator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTeamsAuthorization
implements Middleware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiTeamsAuthorization.class);
    private final AppConfig config;
    private final InstallationService installationService;
    private final TokenRotator tokenRotator;
    private final ConcurrentMap<String, CachedAuthTestResponse> tokenToAuthTestCache = new ConcurrentHashMap<String, CachedAuthTestResponse>();
    private final Optional<ScheduledExecutorService> tokenToAuthTestCacheCleaner;
    private boolean alwaysRequestUserTokenNeeded;

    public boolean isAlwaysRequestUserTokenNeeded() {
        return this.alwaysRequestUserTokenNeeded;
    }

    public void setAlwaysRequestUserTokenNeeded(boolean alwaysRequestUserTokenNeeded) {
        this.alwaysRequestUserTokenNeeded = alwaysRequestUserTokenNeeded;
    }

    public MultiTeamsAuthorization(AppConfig config, InstallationService installationService) {
        this.config = config;
        this.installationService = installationService;
        this.tokenRotator = new TokenRotator(config.getSlack().methods(), config.getTokenRotationExpirationMillis(), config.getClientId(), config.getClientSecret());
        this.setAlwaysRequestUserTokenNeeded(config.isAlwaysRequestUserTokenNeeded());
        if (config.isAuthTestCacheEnabled()) {
            boolean permanentCacheEnabled;
            boolean bl = permanentCacheEnabled = config.getAuthTestCacheExpirationMillis() < 0L;
            this.tokenToAuthTestCacheCleaner = permanentCacheEnabled ? Optional.empty() : Optional.of(this.buildTokenToAuthTestCacheCleaner(() -> {
                long expirationMillis = System.currentTimeMillis() - config.getAuthTestCacheExpirationMillis();
                for (Map.Entry each : this.tokenToAuthTestCache.entrySet()) {
                    if (each.getValue() != null && ((CachedAuthTestResponse)each.getValue()).getCachedMillis() >= expirationMillis) continue;
                    this.tokenToAuthTestCache.remove(each.getKey());
                }
            }));
        } else {
            this.tokenToAuthTestCacheCleaner = Optional.empty();
        }
    }

    private ScheduledExecutorService buildTokenToAuthTestCacheCleaner(Runnable task) {
        String threadGroupName = MultiTeamsAuthorization.class.getSimpleName();
        ScheduledExecutorService tokenToAuthTestCacheCleaner = this.config.getExecutorServiceProvider().createThreadScheduledExecutor(threadGroupName);
        tokenToAuthTestCacheCleaner.scheduleAtFixedRate(task, 120000L, 30000L, TimeUnit.MILLISECONDS);
        log.debug("The tokenToAuthTestCacheCleaner (daemon thread) started");
        return tokenToAuthTestCacheCleaner;
    }

    protected void finalize() throws Throwable {
        if (this.tokenToAuthTestCacheCleaner.isPresent()) {
            this.tokenToAuthTestCacheCleaner.get().shutdown();
        }
        super.finalize();
    }

    @Override
    public Response apply(Request req, Response resp, MiddlewareChain chain) throws Exception {
        if (MiddlewareOps.isNoAuthRequiredRequest(req.getRequestType())) {
            return chain.next(req);
        }
        if (MiddlewareOps.isNoTokenRequiredRequest(req)) {
            return chain.next(req);
        }
        Object context = req.getContext();
        String botToken = null;
        String userToken = null;
        Bot bot = this.installationService.findBot(((Context)context).getEnterpriseId(), ((Context)context).getTeamId());
        Installer installer = null;
        if (bot != null) {
            Optional maybeRefreshed;
            if (bot.getBotRefreshToken() != null && (maybeRefreshed = this.tokenRotator.performTokenRotation(r -> r.accessToken(bot.getBotAccessToken()).refreshToken(bot.getBotRefreshToken()).expiresAt(bot.getBotTokenExpiresAt().longValue()))).isPresent()) {
                RefreshedToken newOne = (RefreshedToken)maybeRefreshed.get();
                bot.setBotAccessToken(newOne.getAccessToken());
                bot.setBotRefreshToken(newOne.getRefreshToken());
                bot.setBotTokenExpiresAt(newOne.getExpiresAt());
                this.installationService.saveBot(bot);
            }
            botToken = bot.getBotAccessToken();
        }
        if ((this.isAlwaysRequestUserTokenNeeded() || bot == null) && ((Context)context).getRequestUserId() != null && (installer = this.installationService.findInstaller(((Context)context).getEnterpriseId(), ((Context)context).getTeamId(), ((Context)context).getRequestUserId())) != null) {
            RefreshedToken newOne;
            Optional maybeRefreshed;
            Installer _i;
            boolean refreshed = false;
            if (installer.getInstallerUserRefreshToken() != null) {
                _i = installer;
                maybeRefreshed = this.tokenRotator.performTokenRotation(r -> r.accessToken(_i.getInstallerUserAccessToken()).refreshToken(_i.getInstallerUserRefreshToken()).expiresAt(_i.getInstallerUserTokenExpiresAt().longValue()));
                boolean bl = refreshed = refreshed || maybeRefreshed.isPresent();
                if (maybeRefreshed.isPresent()) {
                    newOne = (RefreshedToken)maybeRefreshed.get();
                    installer.setInstallerUserAccessToken(newOne.getAccessToken());
                    installer.setInstallerUserRefreshToken(newOne.getRefreshToken());
                    installer.setInstallerUserTokenExpiresAt(newOne.getExpiresAt());
                }
            }
            if (installer.getBotRefreshToken() != null) {
                _i = installer;
                maybeRefreshed = this.tokenRotator.performTokenRotation(r -> r.accessToken(_i.getBotAccessToken()).refreshToken(_i.getBotRefreshToken()).expiresAt(_i.getBotTokenExpiresAt().longValue()));
                boolean bl = refreshed = refreshed || maybeRefreshed.isPresent();
                if (maybeRefreshed.isPresent()) {
                    newOne = (RefreshedToken)maybeRefreshed.get();
                    installer.setBotAccessToken(newOne.getAccessToken());
                    installer.setBotRefreshToken(newOne.getRefreshToken());
                    installer.setBotTokenExpiresAt(newOne.getExpiresAt());
                }
            }
            if (refreshed) {
                this.installationService.saveInstallerAndBot(installer);
            }
            userToken = installer.getInstallerUserAccessToken();
        }
        if (botToken == null && userToken == null) {
            String responseUrl = req.getResponseUrl();
            if (responseUrl != null) {
                Responder responder = new Responder(this.config.getSlack(), responseUrl);
                if (req.getRequestType() != null) {
                    String text;
                    List<LayoutBlock> blocks = this.installationService.getInstallationGuideBlocks(((Context)context).getEnterpriseId(), ((Context)context).getTeamId(), ((Context)context).getRequestUserId());
                    String string = text = blocks == null ? this.installationService.getInstallationGuideText(((Context)context).getEnterpriseId(), ((Context)context).getTeamId(), ((Context)context).getRequestUserId()) : null;
                    if (req.getRequestType().equals((Object)RequestType.Command)) {
                        if (blocks != null) {
                            responder.sendToCommand((RequestConfigurator<SlashCommandResponse.SlashCommandResponseBuilder>)((RequestConfigurator)body -> body.responseType("ephemeral").blocks(blocks)));
                        } else {
                            responder.sendToCommand((RequestConfigurator<SlashCommandResponse.SlashCommandResponseBuilder>)((RequestConfigurator)body -> body.responseType("ephemeral").text(text)));
                        }
                    } else if (blocks != null) {
                        responder.sendToAction((RequestConfigurator<ActionResponse.ActionResponseBuilder>)((RequestConfigurator)body -> body.responseType("ephemeral").blocks(blocks)));
                    } else {
                        responder.sendToAction((RequestConfigurator<ActionResponse.ActionResponseBuilder>)((RequestConfigurator)body -> body.responseType("ephemeral").text(text)));
                    }
                    return Response.builder().statusCode(200).build();
                }
            } else {
                return this.buildError(401, null, null, null);
            }
        }
        try {
            String token = botToken != null ? botToken : userToken;
            AuthTestResponse authTestResponse = this.callAuthTest(token, this.config, ((Context)context).client());
            if (authTestResponse.isOk()) {
                ((Context)context).setAuthTestResponse(authTestResponse);
                ((Context)context).setBotToken(botToken);
                Map botHeaders = authTestResponse.getHttpResponseHeaders();
                List botScopesHeader = botHeaders != null ? (List)botHeaders.get("x-oauth-scopes") : null;
                ((Context)context).setBotScopes(botScopesHeader != null ? Arrays.asList(((String)botScopesHeader.get(0)).split(",")) : null);
                ((Context)context).setRequestUserToken(userToken);
                if (userToken != null && token != userToken) {
                    AuthTestResponse userAuthTestResponse = this.callAuthTest(userToken, this.config, ((Context)context).client());
                    Map userHeaders = userAuthTestResponse.getHttpResponseHeaders();
                    List userScopesHeader = userHeaders != null ? (List)userHeaders.get("x-oauth-scopes") : null;
                    ((Context)context).setRequestUserScopes(userScopesHeader != null ? Arrays.asList(((String)userScopesHeader.get(0)).split(",")) : null);
                }
                if (!authTestResponse.isEnterpriseInstall()) {
                    ((Context)context).setTeamId(authTestResponse.getTeamId());
                }
                ((Context)context).setEnterpriseId(authTestResponse.getEnterpriseId());
                ((Context)context).setEnterpriseInstall(authTestResponse.isEnterpriseInstall());
                if (bot != null) {
                    ((Context)context).setBotId(bot.getBotId());
                    ((Context)context).setBotUserId(authTestResponse.getUserId());
                }
                return chain.next(req);
            }
            return this.handleAuthTestError(authTestResponse.getError(), bot, installer, authTestResponse);
        }
        catch (IOException e) {
            return this.buildError(503, null, e, null);
        }
        catch (SlackApiException e) {
            return this.buildError(503, null, null, e);
        }
    }

    protected AuthTestResponse callAuthTest(String token, AppConfig config, MethodsClient client) throws IOException, SlackApiException {
        if (config.isAuthTestCacheEnabled()) {
            CachedAuthTestResponse cachedResponse = (CachedAuthTestResponse)this.tokenToAuthTestCache.get(token);
            if (cachedResponse != null) {
                boolean permanentCacheEnabled;
                boolean bl = permanentCacheEnabled = config.getAuthTestCacheExpirationMillis() < 0L;
                if (permanentCacheEnabled) {
                    return cachedResponse.getResponse();
                }
                long millisToExpire = cachedResponse.getCachedMillis() + config.getAuthTestCacheExpirationMillis();
                if (millisToExpire > System.currentTimeMillis()) {
                    return cachedResponse.getResponse();
                }
            }
            AuthTestResponse response = client.authTest(r -> r.token(token));
            CachedAuthTestResponse newCache = new CachedAuthTestResponse(response, System.currentTimeMillis());
            this.tokenToAuthTestCache.put(token, newCache);
            return response;
        }
        return client.authTest(r -> r.token(token));
    }

    protected Response handleAuthTestError(String errorCode, Bot foundBot, Installer foundInstaller, AuthTestResponse authTestResponse) throws Exception {
        if (errorCode.equals("account_inactive")) {
            if (foundBot != null) {
                this.installationService.deleteBot(foundBot);
            } else if (foundInstaller != null) {
                this.installationService.deleteInstaller(foundInstaller);
            }
        }
        return this.buildError(401, authTestResponse, null, null);
    }

    protected Response buildError(int statusCode, AuthTestResponse authTestResponse, IOException ioException, SlackApiException slackException) {
        log.info("auth.test result: {}, io error: {}, api error: {}", new Object[]{authTestResponse, ioException, slackException});
        return Response.builder().statusCode(statusCode).contentType("application/json; charset=utf-8").body("{\"error\":\"a request for an unknown workspace detected\"}").build();
    }

    static class CachedAuthTestResponse {
        private AuthTestResponse response;
        private long cachedMillis;

        @Generated
        public AuthTestResponse getResponse() {
            return this.response;
        }

        @Generated
        public long getCachedMillis() {
            return this.cachedMillis;
        }

        @Generated
        public void setResponse(AuthTestResponse response) {
            this.response = response;
        }

        @Generated
        public void setCachedMillis(long cachedMillis) {
            this.cachedMillis = cachedMillis;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachedAuthTestResponse)) {
                return false;
            }
            CachedAuthTestResponse other = (CachedAuthTestResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCachedMillis() != other.getCachedMillis()) {
                return false;
            }
            AuthTestResponse this$response = this.getResponse();
            AuthTestResponse other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !this$response.equals(other$response));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CachedAuthTestResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $cachedMillis = this.getCachedMillis();
            result = result * 59 + (int)($cachedMillis >>> 32 ^ $cachedMillis);
            AuthTestResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : $response.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MultiTeamsAuthorization.CachedAuthTestResponse(response=" + this.getResponse() + ", cachedMillis=" + this.getCachedMillis() + ")";
        }

        @Generated
        public CachedAuthTestResponse(AuthTestResponse response, long cachedMillis) {
            this.response = response;
            this.cachedMillis = cachedMillis;
        }
    }
}

