/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.slash_commands.response.SlashCommandResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.RespondUtility;
import com.slack.api.bolt.context.SayUtility;
import com.slack.api.bolt.response.Responder;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;

public class SlashCommandContext
extends Context
implements SayUtility,
RespondUtility {
    private String triggerId;
    private String channelId;
    private String responseUrl;
    private Responder responder;

    public WebhookResponse respond(String text) throws IOException {
        return this.respond(SlashCommandResponse.builder().text(text).build());
    }

    public WebhookResponse respond(List<LayoutBlock> blocks) throws IOException {
        return this.respond(SlashCommandResponse.builder().blocks(blocks).build());
    }

    public WebhookResponse respond(SlashCommandResponse response) throws IOException {
        if (this.getResponder() == null) {
            this.setResponder(new Responder(this.getSlack(), this.getResponseUrl()));
        }
        return this.getResponder().send(response);
    }

    public WebhookResponse respond(BuilderConfigurator<SlashCommandResponse.SlashCommandResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(SlashCommandResponse.builder()).build());
    }

    public Response ack(String text) {
        return Response.json(200, SlashCommandResponse.builder().text(text).build());
    }

    public Response ack(List<LayoutBlock> blocks) {
        return Response.json(200, SlashCommandResponse.builder().blocks(blocks).build());
    }

    public Response ack(SlashCommandResponse response) {
        return Response.json(200, response);
    }

    public Response ack(BuilderConfigurator<SlashCommandResponse.SlashCommandResponseBuilder> builder) {
        return this.ack(builder.configure(SlashCommandResponse.builder()).build());
    }

    @Generated
    public static SlashCommandContextBuilder builder() {
        return new SlashCommandContextBuilder();
    }

    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    @Generated
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @Generated
    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Override
    @Generated
    public Responder getResponder() {
        return this.responder;
    }

    @Generated
    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    @Generated
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    @Generated
    public void setResponseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
    }

    @Override
    @Generated
    public void setResponder(Responder responder) {
        this.responder = responder;
    }

    @Generated
    public SlashCommandContext() {
    }

    @Generated
    public SlashCommandContext(String triggerId, String channelId, String responseUrl, Responder responder) {
        this.triggerId = triggerId;
        this.channelId = channelId;
        this.responseUrl = responseUrl;
        this.responder = responder;
    }

    @Override
    @Generated
    public String toString() {
        return "SlashCommandContext(super=" + super.toString() + ", triggerId=" + this.getTriggerId() + ", channelId=" + this.getChannelId() + ", responseUrl=" + this.getResponseUrl() + ", responder=" + this.getResponder() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlashCommandContext)) {
            return false;
        }
        SlashCommandContext other = (SlashCommandContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$responseUrl = this.getResponseUrl();
        String other$responseUrl = other.getResponseUrl();
        if (this$responseUrl == null ? other$responseUrl != null : !this$responseUrl.equals(other$responseUrl)) {
            return false;
        }
        Responder this$responder = this.getResponder();
        Responder other$responder = other.getResponder();
        return !(this$responder == null ? other$responder != null : !this$responder.equals(other$responder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SlashCommandContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $responseUrl = this.getResponseUrl();
        result = result * 59 + ($responseUrl == null ? 43 : $responseUrl.hashCode());
        Responder $responder = this.getResponder();
        result = result * 59 + ($responder == null ? 43 : $responder.hashCode());
        return result;
    }

    @Generated
    public static class SlashCommandContextBuilder {
        @Generated
        private String triggerId;
        @Generated
        private String channelId;
        @Generated
        private String responseUrl;
        @Generated
        private Responder responder;

        @Generated
        SlashCommandContextBuilder() {
        }

        @Generated
        public SlashCommandContextBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        @Generated
        public SlashCommandContextBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        @Generated
        public SlashCommandContextBuilder responseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        @Generated
        public SlashCommandContextBuilder responder(Responder responder) {
            this.responder = responder;
            return this;
        }

        @Generated
        public SlashCommandContext build() {
            return new SlashCommandContext(this.triggerId, this.channelId, this.responseUrl, this.responder);
        }

        @Generated
        public String toString() {
            return "SlashCommandContext.SlashCommandContextBuilder(triggerId=" + this.triggerId + ", channelId=" + this.channelId + ", responseUrl=" + this.responseUrl + ", responder=" + this.responder + ")";
        }
    }
}

