/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.dialogs.payload.DialogCancellationPayload;
import com.slack.api.bolt.context.builtin.DialogCancellationContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class DialogCancellationRequest
extends Request<DialogCancellationContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final DialogCancellationPayload payload;
    private DialogCancellationContext context = new DialogCancellationContext();

    public DialogCancellationRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (DialogCancellationPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, DialogCancellationPayload.class);
        this.getContext().setResponseUrl(this.payload.getResponseUrl());
        this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        this.getContext().setTeamId(this.payload.getTeam().getId());
        if (this.payload.getChannel() != null) {
            this.getContext().setChannelId(this.payload.getChannel().getId());
        }
        this.getContext().setRequestUserId(this.payload.getUser().getId());
    }

    @Override
    public DialogCancellationContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.DialogCancellation;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public DialogCancellationPayload getPayload() {
        return this.payload;
    }

    @Override
    public String getResponseUrl() {
        return this.getPayload() != null ? this.getPayload().getResponseUrl() : null;
    }

    @Override
    @Generated
    public String toString() {
        return "DialogCancellationRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

