/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.response;

import com.slack.api.bolt.util.JsonOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Response {
    private Integer statusCode;
    private String contentType;
    private Map<String, List<String>> headers;
    private String body;
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";

    public static Response ok() {
        return Response.builder().statusCode(200).build();
    }

    public static Response ok(Object body) {
        if (body instanceof String) {
            return Response.builder().statusCode(200).body((String)body).build();
        }
        String json = JsonOps.toJsonString(body);
        return Response.builder().statusCode(200).contentType(CONTENT_TYPE_APPLICATION_JSON).body(json).build();
    }

    public static Response error(Integer statusCode) {
        return Response.builder().statusCode(statusCode).build();
    }

    public static Response json(Integer statusCode, Object body) {
        return Response.builder().statusCode(statusCode).contentType(CONTENT_TYPE_APPLICATION_JSON).body(JsonOps.toJsonString(body)).build();
    }

    @Generated
    private static Integer $default$statusCode() {
        return 200;
    }

    @Generated
    private static String $default$contentType() {
        return "plain/text";
    }

    @Generated
    private static Map<String, List<String>> $default$headers() {
        return new HashMap<String, List<String>>();
    }

    @Generated
    public static ResponseBuilder builder() {
        return new ResponseBuilder();
    }

    @Generated
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    @Generated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Generated
    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$statusCode = this.getStatusCode();
        Integer other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Response(statusCode=" + this.getStatusCode() + ", contentType=" + this.getContentType() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ")";
    }

    @Generated
    public Response() {
        this.statusCode = Response.$default$statusCode();
        this.contentType = Response.$default$contentType();
        this.headers = Response.$default$headers();
    }

    @Generated
    public Response(Integer statusCode, String contentType, Map<String, List<String>> headers, String body) {
        this.statusCode = statusCode;
        this.contentType = contentType;
        this.headers = headers;
        this.body = body;
    }

    @Generated
    public static class ResponseBuilder {
        @Generated
        private boolean statusCode$set;
        @Generated
        private Integer statusCode$value;
        @Generated
        private boolean contentType$set;
        @Generated
        private String contentType$value;
        @Generated
        private boolean headers$set;
        @Generated
        private Map<String, List<String>> headers$value;
        @Generated
        private String body;

        @Generated
        ResponseBuilder() {
        }

        @Generated
        public ResponseBuilder statusCode(Integer statusCode) {
            this.statusCode$value = statusCode;
            this.statusCode$set = true;
            return this;
        }

        @Generated
        public ResponseBuilder contentType(String contentType) {
            this.contentType$value = contentType;
            this.contentType$set = true;
            return this;
        }

        @Generated
        public ResponseBuilder headers(Map<String, List<String>> headers) {
            this.headers$value = headers;
            this.headers$set = true;
            return this;
        }

        @Generated
        public ResponseBuilder body(String body) {
            this.body = body;
            return this;
        }

        @Generated
        public Response build() {
            Integer statusCode$value = this.statusCode$value;
            if (!this.statusCode$set) {
                statusCode$value = Response.$default$statusCode();
            }
            String contentType$value = this.contentType$value;
            if (!this.contentType$set) {
                contentType$value = Response.$default$contentType();
            }
            Map headers$value = this.headers$value;
            if (!this.headers$set) {
                headers$value = Response.$default$headers();
            }
            return new Response(statusCode$value, contentType$value, headers$value, this.body);
        }

        @Generated
        public String toString() {
            return "Response.ResponseBuilder(statusCode$value=" + this.statusCode$value + ", contentType$value=" + this.contentType$value + ", headers$value=" + this.headers$value + ", body=" + this.body + ")";
        }
    }
}

