/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.servlet;

import com.slack.api.bolt.response.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletAdapterOps {
    private ServletAdapterOps() {
    }

    public static String doReadRequestBodyAsString(HttpServletRequest req) throws IOException {
        return req.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public static Map<String, List<String>> toHeaderMap(HttpServletRequest req) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ArrayList values = Collections.list(req.getHeaders(name));
            headers.put(name, values);
        }
        return headers;
    }

    public static void writeResponse(HttpServletResponse resp, Response slackResp) throws IOException {
        resp.setStatus(slackResp.getStatusCode().intValue());
        for (Map.Entry<String, List<String>> header : slackResp.getHeaders().entrySet()) {
            String name = header.getKey();
            for (String value : header.getValue()) {
                resp.addHeader(name, value);
            }
        }
        resp.setHeader("Content-Type", slackResp.getContentType());
        if (slackResp.getBody() != null) {
            resp.getWriter().write(slackResp.getBody());
        }
    }
}

