/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.dialogs.payload.DialogSubmissionPayload;
import com.slack.api.bolt.context.builtin.DialogSubmissionContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class DialogSubmissionRequest
extends Request<DialogSubmissionContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final DialogSubmissionPayload payload;
    private DialogSubmissionContext context = new DialogSubmissionContext();

    public DialogSubmissionRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (DialogSubmissionPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, DialogSubmissionPayload.class);
        this.getContext().setResponseUrl(this.payload.getResponseUrl());
        this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        this.getContext().setTeamId(this.payload.getTeam().getId());
        if (this.payload.getChannel() != null) {
            this.getContext().setChannelId(this.payload.getChannel().getId());
        }
        this.getContext().setRequestUserId(this.payload.getUser().getId());
    }

    @Override
    public DialogSubmissionContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.DialogSubmission;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public DialogSubmissionPayload getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public String toString() {
        return "DialogSubmissionRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

