/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context.builtin;

import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.bolt.context.Context;
import com.slack.api.bolt.context.SayUtility;
import com.slack.api.bolt.response.Responder;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;

public class DialogCancellationContext
extends Context
implements SayUtility {
    private String responseUrl;
    private String channelId;
    private Responder responder;

    public WebhookResponse respond(String text) throws IOException {
        return this.respond(ActionResponse.builder().text(text).build());
    }

    public WebhookResponse respond(List<LayoutBlock> blocks) throws IOException {
        return this.respond(ActionResponse.builder().blocks(blocks).build());
    }

    public WebhookResponse respond(ActionResponse response) throws IOException {
        if (this.responder == null) {
            this.responder = new Responder(this.slack, this.responseUrl);
        }
        return this.responder.send(response);
    }

    public WebhookResponse respond(BuilderConfigurator<ActionResponse.ActionResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(ActionResponse.builder()).build());
    }

    @Generated
    public static DialogCancellationContextBuilder builder() {
        return new DialogCancellationContextBuilder();
    }

    @Generated
    public String getResponseUrl() {
        return this.responseUrl;
    }

    @Override
    @Generated
    public String getChannelId() {
        return this.channelId;
    }

    @Generated
    public Responder getResponder() {
        return this.responder;
    }

    @Generated
    public void setResponseUrl(String responseUrl) {
        this.responseUrl = responseUrl;
    }

    @Generated
    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    @Generated
    public void setResponder(Responder responder) {
        this.responder = responder;
    }

    @Generated
    public DialogCancellationContext() {
    }

    @Generated
    public DialogCancellationContext(String responseUrl, String channelId, Responder responder) {
        this.responseUrl = responseUrl;
        this.channelId = channelId;
        this.responder = responder;
    }

    @Override
    @Generated
    public String toString() {
        return "DialogCancellationContext(super=" + super.toString() + ", responseUrl=" + this.getResponseUrl() + ", channelId=" + this.getChannelId() + ", responder=" + this.getResponder() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DialogCancellationContext)) {
            return false;
        }
        DialogCancellationContext other = (DialogCancellationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$responseUrl = this.getResponseUrl();
        String other$responseUrl = other.getResponseUrl();
        if (this$responseUrl == null ? other$responseUrl != null : !this$responseUrl.equals(other$responseUrl)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        Responder this$responder = this.getResponder();
        Responder other$responder = other.getResponder();
        return !(this$responder == null ? other$responder != null : !this$responder.equals(other$responder));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DialogCancellationContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $responseUrl = this.getResponseUrl();
        result = result * 59 + ($responseUrl == null ? 43 : $responseUrl.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        Responder $responder = this.getResponder();
        result = result * 59 + ($responder == null ? 43 : $responder.hashCode());
        return result;
    }

    @Generated
    public static class DialogCancellationContextBuilder {
        @Generated
        private String responseUrl;
        @Generated
        private String channelId;
        @Generated
        private Responder responder;

        @Generated
        DialogCancellationContextBuilder() {
        }

        @Generated
        public DialogCancellationContextBuilder responseUrl(String responseUrl) {
            this.responseUrl = responseUrl;
            return this;
        }

        @Generated
        public DialogCancellationContextBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        @Generated
        public DialogCancellationContextBuilder responder(Responder responder) {
            this.responder = responder;
            return this;
        }

        @Generated
        public DialogCancellationContext build() {
            return new DialogCancellationContext(this.responseUrl, this.channelId, this.responder);
        }

        @Generated
        public String toString() {
            return "DialogCancellationContext.DialogCancellationContextBuilder(responseUrl=" + this.responseUrl + ", channelId=" + this.channelId + ", responder=" + this.responder + ")";
        }
    }
}

