/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context;

import com.google.gson.JsonElement;
import com.slack.api.Slack;
import com.slack.api.bolt.App;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.bolt.util.JsonOps;
import com.slack.api.methods.AsyncMethodsClient;
import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.request.chat.ChatPostMessageRequest;
import com.slack.api.methods.response.chat.ChatPostMessageResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Context {
    protected Slack slack;
    public final Logger logger = LoggerFactory.getLogger(App.class);
    protected String enterpriseId;
    protected String teamId;
    protected String botToken;
    protected String botId;
    protected String botUserId;
    protected String requestUserId;
    protected String requestUserToken;
    protected final Map<String, String> additionalValues = new HashMap<String, String>();

    public MethodsClient client() {
        return this.slack.methods(this.botToken);
    }

    public AsyncMethodsClient asyncClient() {
        return this.slack.methodsAsync(this.botToken);
    }

    public ChatPostMessageResponse say(BuilderConfigurator<ChatPostMessageRequest.ChatPostMessageRequestBuilder> request) throws IOException, SlackApiException {
        ChatPostMessageResponse response = this.client().chatPostMessage(request.configure(ChatPostMessageRequest.builder()).build());
        return response;
    }

    public Response ack() {
        return Response.ok();
    }

    public Response ackWithJson(Object obj) {
        return this.ack(this.toJson(obj));
    }

    public Response ack(JsonElement json) {
        return Response.json(200, json);
    }

    public JsonElement toJson(Object obj) {
        return JsonOps.toJson(obj);
    }

    @Generated
    public String toString() {
        return "Context(slack=" + this.getSlack() + ", logger=" + this.getLogger() + ", enterpriseId=" + this.getEnterpriseId() + ", teamId=" + this.getTeamId() + ", botToken=" + this.getBotToken() + ", botId=" + this.getBotId() + ", botUserId=" + this.getBotUserId() + ", requestUserId=" + this.getRequestUserId() + ", requestUserToken=" + this.getRequestUserToken() + ", additionalValues=" + this.getAdditionalValues() + ")";
    }

    @Generated
    public Slack getSlack() {
        return this.slack;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    @Generated
    public String getTeamId() {
        return this.teamId;
    }

    @Generated
    public String getBotToken() {
        return this.botToken;
    }

    @Generated
    public String getBotId() {
        return this.botId;
    }

    @Generated
    public String getBotUserId() {
        return this.botUserId;
    }

    @Generated
    public String getRequestUserId() {
        return this.requestUserId;
    }

    @Generated
    public String getRequestUserToken() {
        return this.requestUserToken;
    }

    @Generated
    public Map<String, String> getAdditionalValues() {
        return this.additionalValues;
    }

    @Generated
    public void setSlack(Slack slack) {
        this.slack = slack;
    }

    @Generated
    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    @Generated
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    @Generated
    public void setBotToken(String botToken) {
        this.botToken = botToken;
    }

    @Generated
    public void setBotId(String botId) {
        this.botId = botId;
    }

    @Generated
    public void setBotUserId(String botUserId) {
        this.botUserId = botUserId;
    }

    @Generated
    public void setRequestUserId(String requestUserId) {
        this.requestUserId = requestUserId;
    }

    @Generated
    public void setRequestUserToken(String requestUserToken) {
        this.requestUserToken = requestUserToken;
    }
}

