/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RequestHeaders {
    private final Map<String, List<String>> underlying = new HashMap<String, List<String>>();

    public Set<String> getNames() {
        return this.underlying.keySet();
    }

    public RequestHeaders(Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            this.underlying.put(RequestHeaders.normalizeKey(entry.getKey()), entry.getValue());
        }
    }

    public String getFirstValue(String name) {
        List<String> values = this.underlying.get(RequestHeaders.normalizeKey(name));
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public List<String> getMultipleValues(String name) {
        return this.underlying.get(name.toLowerCase(Locale.ENGLISH));
    }

    private static String normalizeKey(String name) {
        return name != null ? name.toLowerCase(Locale.ENGLISH) : null;
    }

    public String toString() {
        return "RequestHeaders(underlying=" + this.underlying + ")";
    }
}

