/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt;

import com.slack.api.Slack;
import com.slack.api.SlackConfig;
import com.slack.api.util.http.SlackHttpClient;
import java.util.HashMap;
import java.util.Optional;

public class AppConfig {
    private Slack slack;
    private String singleTeamBotToken;
    private String signingSecret;
    @Deprecated
    private String verificationToken;
    private boolean oAuthStartEnabled;
    private boolean oAuthCallbackEnabled;
    private boolean classicAppPermissionsEnabled;
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private String scope;
    private String userScope;
    private String appPath;
    private String oauthStartPath;
    private String oauthCallbackPath;
    private String oauthCancellationUrl;
    private String oauthCompletionUrl;
    private boolean alwaysRequestUserTokenNeeded;

    private static SlackHttpClient buildSlackHttpClient() {
        HashMap<String, String> userAgentCustomInfo = new HashMap<String, String>();
        String version = AppConfig.class.getPackage().getImplementationVersion();
        userAgentCustomInfo.put("bolt", version == null ? "unknown" : version);
        SlackHttpClient client = new SlackHttpClient(userAgentCustomInfo);
        return client;
    }

    public boolean isDistributedApp() {
        return this.clientId != null && this.clientSecret != null;
    }

    public void setOauthStartPath(String oauthStartPath) {
        this.oauthStartPath = oauthStartPath;
        this.oAuthStartEnabled = oauthStartPath != null;
    }

    public void setOauthCallbackPath(String oauthCallbackPath) {
        this.oauthCallbackPath = oauthCallbackPath;
        this.oAuthCallbackEnabled = oauthCallbackPath != null;
    }

    public String getOauthStartRequestURI() {
        return this.appPath + this.oauthStartPath;
    }

    public String getOauthCallbackRequestURI() {
        return this.appPath + this.oauthCallbackPath;
    }

    private static Slack $default$slack() {
        return Slack.getInstance((SlackConfig)SlackConfig.DEFAULT, (SlackHttpClient)AppConfig.buildSlackHttpClient());
    }

    private static String $default$singleTeamBotToken() {
        return System.getenv("SLACK_BOT_TOKEN");
    }

    private static String $default$signingSecret() {
        return System.getenv("SLACK_SIGNING_SECRET");
    }

    private static String $default$verificationToken() {
        return System.getenv("SLACK_VERIFICATION_TOKEN");
    }

    private static boolean $default$oAuthStartEnabled() {
        return false;
    }

    private static boolean $default$oAuthCallbackEnabled() {
        return false;
    }

    private static boolean $default$classicAppPermissionsEnabled() {
        return false;
    }

    private static String $default$clientId() {
        return System.getenv("SLACK_APP_CLIENT_ID");
    }

    private static String $default$clientSecret() {
        return System.getenv("SLACK_APP_CLIENT_SECRET");
    }

    private static String $default$redirectUri() {
        return System.getenv("SLACK_APP_REDIRECT_URI");
    }

    private static String $default$scope() {
        return System.getenv("SLACK_APP_SCOPE");
    }

    private static String $default$userScope() {
        return System.getenv("SLACK_APP_USER_SCOPE");
    }

    private static String $default$oauthStartPath() {
        return Optional.ofNullable(System.getenv("SLACK_APP_OAUTH_START_PATH")).orElse("start");
    }

    private static String $default$oauthCallbackPath() {
        return Optional.ofNullable(System.getenv("SLACK_APP_OAUTH_CALLBACK_PATH")).orElse("callback");
    }

    private static String $default$oauthCancellationUrl() {
        return System.getenv("SLACK_APP_OAUTH_CANCELLATION_URL");
    }

    private static String $default$oauthCompletionUrl() {
        return System.getenv("SLACK_APP_OAUTH_COMPLETION_URL");
    }

    public static AppConfigBuilder builder() {
        return new AppConfigBuilder();
    }

    public AppConfigBuilder toBuilder() {
        return new AppConfigBuilder().slack(this.slack).singleTeamBotToken(this.singleTeamBotToken).signingSecret(this.signingSecret).verificationToken(this.verificationToken).oAuthStartEnabled(this.oAuthStartEnabled).oAuthCallbackEnabled(this.oAuthCallbackEnabled).classicAppPermissionsEnabled(this.classicAppPermissionsEnabled).clientId(this.clientId).clientSecret(this.clientSecret).redirectUri(this.redirectUri).scope(this.scope).userScope(this.userScope).appPath(this.appPath).oauthStartPath(this.oauthStartPath).oauthCallbackPath(this.oauthCallbackPath).oauthCancellationUrl(this.oauthCancellationUrl).oauthCompletionUrl(this.oauthCompletionUrl).alwaysRequestUserTokenNeeded(this.alwaysRequestUserTokenNeeded);
    }

    public Slack getSlack() {
        return this.slack;
    }

    public String getSingleTeamBotToken() {
        return this.singleTeamBotToken;
    }

    public String getSigningSecret() {
        return this.signingSecret;
    }

    @Deprecated
    public String getVerificationToken() {
        return this.verificationToken;
    }

    public boolean isOAuthStartEnabled() {
        return this.oAuthStartEnabled;
    }

    public boolean isOAuthCallbackEnabled() {
        return this.oAuthCallbackEnabled;
    }

    public boolean isClassicAppPermissionsEnabled() {
        return this.classicAppPermissionsEnabled;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getScope() {
        return this.scope;
    }

    public String getUserScope() {
        return this.userScope;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public String getOauthStartPath() {
        return this.oauthStartPath;
    }

    public String getOauthCallbackPath() {
        return this.oauthCallbackPath;
    }

    public String getOauthCancellationUrl() {
        return this.oauthCancellationUrl;
    }

    public String getOauthCompletionUrl() {
        return this.oauthCompletionUrl;
    }

    public boolean isAlwaysRequestUserTokenNeeded() {
        return this.alwaysRequestUserTokenNeeded;
    }

    public void setSlack(Slack slack) {
        this.slack = slack;
    }

    public void setSingleTeamBotToken(String singleTeamBotToken) {
        this.singleTeamBotToken = singleTeamBotToken;
    }

    public void setSigningSecret(String signingSecret) {
        this.signingSecret = signingSecret;
    }

    @Deprecated
    public void setVerificationToken(String verificationToken) {
        this.verificationToken = verificationToken;
    }

    public void setOAuthStartEnabled(boolean oAuthStartEnabled) {
        this.oAuthStartEnabled = oAuthStartEnabled;
    }

    public void setOAuthCallbackEnabled(boolean oAuthCallbackEnabled) {
        this.oAuthCallbackEnabled = oAuthCallbackEnabled;
    }

    public void setClassicAppPermissionsEnabled(boolean classicAppPermissionsEnabled) {
        this.classicAppPermissionsEnabled = classicAppPermissionsEnabled;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setUserScope(String userScope) {
        this.userScope = userScope;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public void setOauthCancellationUrl(String oauthCancellationUrl) {
        this.oauthCancellationUrl = oauthCancellationUrl;
    }

    public void setOauthCompletionUrl(String oauthCompletionUrl) {
        this.oauthCompletionUrl = oauthCompletionUrl;
    }

    public void setAlwaysRequestUserTokenNeeded(boolean alwaysRequestUserTokenNeeded) {
        this.alwaysRequestUserTokenNeeded = alwaysRequestUserTokenNeeded;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppConfig)) {
            return false;
        }
        AppConfig other = (AppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Slack this$slack = this.getSlack();
        Slack other$slack = other.getSlack();
        if (this$slack == null ? other$slack != null : !this$slack.equals(other$slack)) {
            return false;
        }
        String this$singleTeamBotToken = this.getSingleTeamBotToken();
        String other$singleTeamBotToken = other.getSingleTeamBotToken();
        if (this$singleTeamBotToken == null ? other$singleTeamBotToken != null : !this$singleTeamBotToken.equals(other$singleTeamBotToken)) {
            return false;
        }
        String this$signingSecret = this.getSigningSecret();
        String other$signingSecret = other.getSigningSecret();
        if (this$signingSecret == null ? other$signingSecret != null : !this$signingSecret.equals(other$signingSecret)) {
            return false;
        }
        String this$verificationToken = this.getVerificationToken();
        String other$verificationToken = other.getVerificationToken();
        if (this$verificationToken == null ? other$verificationToken != null : !this$verificationToken.equals(other$verificationToken)) {
            return false;
        }
        if (this.isOAuthStartEnabled() != other.isOAuthStartEnabled()) {
            return false;
        }
        if (this.isOAuthCallbackEnabled() != other.isOAuthCallbackEnabled()) {
            return false;
        }
        if (this.isClassicAppPermissionsEnabled() != other.isClassicAppPermissionsEnabled()) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$userScope = this.getUserScope();
        String other$userScope = other.getUserScope();
        if (this$userScope == null ? other$userScope != null : !this$userScope.equals(other$userScope)) {
            return false;
        }
        String this$appPath = this.getAppPath();
        String other$appPath = other.getAppPath();
        if (this$appPath == null ? other$appPath != null : !this$appPath.equals(other$appPath)) {
            return false;
        }
        String this$oauthStartPath = this.getOauthStartPath();
        String other$oauthStartPath = other.getOauthStartPath();
        if (this$oauthStartPath == null ? other$oauthStartPath != null : !this$oauthStartPath.equals(other$oauthStartPath)) {
            return false;
        }
        String this$oauthCallbackPath = this.getOauthCallbackPath();
        String other$oauthCallbackPath = other.getOauthCallbackPath();
        if (this$oauthCallbackPath == null ? other$oauthCallbackPath != null : !this$oauthCallbackPath.equals(other$oauthCallbackPath)) {
            return false;
        }
        String this$oauthCancellationUrl = this.getOauthCancellationUrl();
        String other$oauthCancellationUrl = other.getOauthCancellationUrl();
        if (this$oauthCancellationUrl == null ? other$oauthCancellationUrl != null : !this$oauthCancellationUrl.equals(other$oauthCancellationUrl)) {
            return false;
        }
        String this$oauthCompletionUrl = this.getOauthCompletionUrl();
        String other$oauthCompletionUrl = other.getOauthCompletionUrl();
        if (this$oauthCompletionUrl == null ? other$oauthCompletionUrl != null : !this$oauthCompletionUrl.equals(other$oauthCompletionUrl)) {
            return false;
        }
        return this.isAlwaysRequestUserTokenNeeded() == other.isAlwaysRequestUserTokenNeeded();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Slack $slack = this.getSlack();
        result = result * 59 + ($slack == null ? 43 : $slack.hashCode());
        String $singleTeamBotToken = this.getSingleTeamBotToken();
        result = result * 59 + ($singleTeamBotToken == null ? 43 : $singleTeamBotToken.hashCode());
        String $signingSecret = this.getSigningSecret();
        result = result * 59 + ($signingSecret == null ? 43 : $signingSecret.hashCode());
        String $verificationToken = this.getVerificationToken();
        result = result * 59 + ($verificationToken == null ? 43 : $verificationToken.hashCode());
        result = result * 59 + (this.isOAuthStartEnabled() ? 79 : 97);
        result = result * 59 + (this.isOAuthCallbackEnabled() ? 79 : 97);
        result = result * 59 + (this.isClassicAppPermissionsEnabled() ? 79 : 97);
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $userScope = this.getUserScope();
        result = result * 59 + ($userScope == null ? 43 : $userScope.hashCode());
        String $appPath = this.getAppPath();
        result = result * 59 + ($appPath == null ? 43 : $appPath.hashCode());
        String $oauthStartPath = this.getOauthStartPath();
        result = result * 59 + ($oauthStartPath == null ? 43 : $oauthStartPath.hashCode());
        String $oauthCallbackPath = this.getOauthCallbackPath();
        result = result * 59 + ($oauthCallbackPath == null ? 43 : $oauthCallbackPath.hashCode());
        String $oauthCancellationUrl = this.getOauthCancellationUrl();
        result = result * 59 + ($oauthCancellationUrl == null ? 43 : $oauthCancellationUrl.hashCode());
        String $oauthCompletionUrl = this.getOauthCompletionUrl();
        result = result * 59 + ($oauthCompletionUrl == null ? 43 : $oauthCompletionUrl.hashCode());
        result = result * 59 + (this.isAlwaysRequestUserTokenNeeded() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AppConfig(slack=" + this.getSlack() + ", singleTeamBotToken=" + this.getSingleTeamBotToken() + ", signingSecret=" + this.getSigningSecret() + ", verificationToken=" + this.getVerificationToken() + ", oAuthStartEnabled=" + this.isOAuthStartEnabled() + ", oAuthCallbackEnabled=" + this.isOAuthCallbackEnabled() + ", classicAppPermissionsEnabled=" + this.isClassicAppPermissionsEnabled() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", redirectUri=" + this.getRedirectUri() + ", scope=" + this.getScope() + ", userScope=" + this.getUserScope() + ", appPath=" + this.getAppPath() + ", oauthStartPath=" + this.getOauthStartPath() + ", oauthCallbackPath=" + this.getOauthCallbackPath() + ", oauthCancellationUrl=" + this.getOauthCancellationUrl() + ", oauthCompletionUrl=" + this.getOauthCompletionUrl() + ", alwaysRequestUserTokenNeeded=" + this.isAlwaysRequestUserTokenNeeded() + ")";
    }

    public AppConfig() {
        this.slack = AppConfig.$default$slack();
        this.singleTeamBotToken = AppConfig.$default$singleTeamBotToken();
        this.signingSecret = AppConfig.$default$signingSecret();
        this.verificationToken = AppConfig.$default$verificationToken();
        this.oAuthStartEnabled = AppConfig.$default$oAuthStartEnabled();
        this.oAuthCallbackEnabled = AppConfig.$default$oAuthCallbackEnabled();
        this.classicAppPermissionsEnabled = AppConfig.$default$classicAppPermissionsEnabled();
        this.clientId = AppConfig.$default$clientId();
        this.clientSecret = AppConfig.$default$clientSecret();
        this.redirectUri = AppConfig.$default$redirectUri();
        this.scope = AppConfig.$default$scope();
        this.userScope = AppConfig.$default$userScope();
        this.oauthStartPath = AppConfig.$default$oauthStartPath();
        this.oauthCallbackPath = AppConfig.$default$oauthCallbackPath();
        this.oauthCancellationUrl = AppConfig.$default$oauthCancellationUrl();
        this.oauthCompletionUrl = AppConfig.$default$oauthCompletionUrl();
    }

    public AppConfig(Slack slack, String singleTeamBotToken, String signingSecret, String verificationToken, boolean oAuthStartEnabled, boolean oAuthCallbackEnabled, boolean classicAppPermissionsEnabled, String clientId, String clientSecret, String redirectUri, String scope, String userScope, String appPath, String oauthStartPath, String oauthCallbackPath, String oauthCancellationUrl, String oauthCompletionUrl, boolean alwaysRequestUserTokenNeeded) {
        this.slack = slack;
        this.singleTeamBotToken = singleTeamBotToken;
        this.signingSecret = signingSecret;
        this.verificationToken = verificationToken;
        this.oAuthStartEnabled = oAuthStartEnabled;
        this.oAuthCallbackEnabled = oAuthCallbackEnabled;
        this.classicAppPermissionsEnabled = classicAppPermissionsEnabled;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.scope = scope;
        this.userScope = userScope;
        this.appPath = appPath;
        this.oauthStartPath = oauthStartPath;
        this.oauthCallbackPath = oauthCallbackPath;
        this.oauthCancellationUrl = oauthCancellationUrl;
        this.oauthCompletionUrl = oauthCompletionUrl;
        this.alwaysRequestUserTokenNeeded = alwaysRequestUserTokenNeeded;
    }

    public static class AppConfigBuilder {
        private boolean slack$set;
        private Slack slack$value;
        private boolean singleTeamBotToken$set;
        private String singleTeamBotToken$value;
        private boolean signingSecret$set;
        private String signingSecret$value;
        private boolean verificationToken$set;
        private String verificationToken$value;
        private boolean oAuthStartEnabled$set;
        private boolean oAuthStartEnabled$value;
        private boolean oAuthCallbackEnabled$set;
        private boolean oAuthCallbackEnabled$value;
        private boolean classicAppPermissionsEnabled$set;
        private boolean classicAppPermissionsEnabled$value;
        private boolean clientId$set;
        private String clientId$value;
        private boolean clientSecret$set;
        private String clientSecret$value;
        private boolean redirectUri$set;
        private String redirectUri$value;
        private boolean scope$set;
        private String scope$value;
        private boolean userScope$set;
        private String userScope$value;
        private String appPath;
        private boolean oauthStartPath$set;
        private String oauthStartPath$value;
        private boolean oauthCallbackPath$set;
        private String oauthCallbackPath$value;
        private boolean oauthCancellationUrl$set;
        private String oauthCancellationUrl$value;
        private boolean oauthCompletionUrl$set;
        private String oauthCompletionUrl$value;
        private boolean alwaysRequestUserTokenNeeded;

        AppConfigBuilder() {
        }

        public AppConfigBuilder slack(Slack slack) {
            this.slack$value = slack;
            this.slack$set = true;
            return this;
        }

        public AppConfigBuilder singleTeamBotToken(String singleTeamBotToken) {
            this.singleTeamBotToken$value = singleTeamBotToken;
            this.singleTeamBotToken$set = true;
            return this;
        }

        public AppConfigBuilder signingSecret(String signingSecret) {
            this.signingSecret$value = signingSecret;
            this.signingSecret$set = true;
            return this;
        }

        @Deprecated
        public AppConfigBuilder verificationToken(String verificationToken) {
            this.verificationToken$value = verificationToken;
            this.verificationToken$set = true;
            return this;
        }

        public AppConfigBuilder oAuthStartEnabled(boolean oAuthStartEnabled) {
            this.oAuthStartEnabled$value = oAuthStartEnabled;
            this.oAuthStartEnabled$set = true;
            return this;
        }

        public AppConfigBuilder oAuthCallbackEnabled(boolean oAuthCallbackEnabled) {
            this.oAuthCallbackEnabled$value = oAuthCallbackEnabled;
            this.oAuthCallbackEnabled$set = true;
            return this;
        }

        public AppConfigBuilder classicAppPermissionsEnabled(boolean classicAppPermissionsEnabled) {
            this.classicAppPermissionsEnabled$value = classicAppPermissionsEnabled;
            this.classicAppPermissionsEnabled$set = true;
            return this;
        }

        public AppConfigBuilder clientId(String clientId) {
            this.clientId$value = clientId;
            this.clientId$set = true;
            return this;
        }

        public AppConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret$value = clientSecret;
            this.clientSecret$set = true;
            return this;
        }

        public AppConfigBuilder redirectUri(String redirectUri) {
            this.redirectUri$value = redirectUri;
            this.redirectUri$set = true;
            return this;
        }

        public AppConfigBuilder scope(String scope) {
            this.scope$value = scope;
            this.scope$set = true;
            return this;
        }

        public AppConfigBuilder userScope(String userScope) {
            this.userScope$value = userScope;
            this.userScope$set = true;
            return this;
        }

        public AppConfigBuilder appPath(String appPath) {
            this.appPath = appPath;
            return this;
        }

        public AppConfigBuilder oauthStartPath(String oauthStartPath) {
            this.oauthStartPath$value = oauthStartPath;
            this.oauthStartPath$set = true;
            return this;
        }

        public AppConfigBuilder oauthCallbackPath(String oauthCallbackPath) {
            this.oauthCallbackPath$value = oauthCallbackPath;
            this.oauthCallbackPath$set = true;
            return this;
        }

        public AppConfigBuilder oauthCancellationUrl(String oauthCancellationUrl) {
            this.oauthCancellationUrl$value = oauthCancellationUrl;
            this.oauthCancellationUrl$set = true;
            return this;
        }

        public AppConfigBuilder oauthCompletionUrl(String oauthCompletionUrl) {
            this.oauthCompletionUrl$value = oauthCompletionUrl;
            this.oauthCompletionUrl$set = true;
            return this;
        }

        public AppConfigBuilder alwaysRequestUserTokenNeeded(boolean alwaysRequestUserTokenNeeded) {
            this.alwaysRequestUserTokenNeeded = alwaysRequestUserTokenNeeded;
            return this;
        }

        public AppConfig build() {
            Slack slack$value = this.slack$value;
            if (!this.slack$set) {
                slack$value = AppConfig.$default$slack();
            }
            String singleTeamBotToken$value = this.singleTeamBotToken$value;
            if (!this.singleTeamBotToken$set) {
                singleTeamBotToken$value = AppConfig.$default$singleTeamBotToken();
            }
            String signingSecret$value = this.signingSecret$value;
            if (!this.signingSecret$set) {
                signingSecret$value = AppConfig.$default$signingSecret();
            }
            String verificationToken$value = this.verificationToken$value;
            if (!this.verificationToken$set) {
                verificationToken$value = AppConfig.$default$verificationToken();
            }
            boolean oAuthStartEnabled$value = this.oAuthStartEnabled$value;
            if (!this.oAuthStartEnabled$set) {
                oAuthStartEnabled$value = AppConfig.$default$oAuthStartEnabled();
            }
            boolean oAuthCallbackEnabled$value = this.oAuthCallbackEnabled$value;
            if (!this.oAuthCallbackEnabled$set) {
                oAuthCallbackEnabled$value = AppConfig.$default$oAuthCallbackEnabled();
            }
            boolean classicAppPermissionsEnabled$value = this.classicAppPermissionsEnabled$value;
            if (!this.classicAppPermissionsEnabled$set) {
                classicAppPermissionsEnabled$value = AppConfig.$default$classicAppPermissionsEnabled();
            }
            String clientId$value = this.clientId$value;
            if (!this.clientId$set) {
                clientId$value = AppConfig.$default$clientId();
            }
            String clientSecret$value = this.clientSecret$value;
            if (!this.clientSecret$set) {
                clientSecret$value = AppConfig.$default$clientSecret();
            }
            String redirectUri$value = this.redirectUri$value;
            if (!this.redirectUri$set) {
                redirectUri$value = AppConfig.$default$redirectUri();
            }
            String scope$value = this.scope$value;
            if (!this.scope$set) {
                scope$value = AppConfig.$default$scope();
            }
            String userScope$value = this.userScope$value;
            if (!this.userScope$set) {
                userScope$value = AppConfig.$default$userScope();
            }
            String oauthStartPath$value = this.oauthStartPath$value;
            if (!this.oauthStartPath$set) {
                oauthStartPath$value = AppConfig.$default$oauthStartPath();
            }
            String oauthCallbackPath$value = this.oauthCallbackPath$value;
            if (!this.oauthCallbackPath$set) {
                oauthCallbackPath$value = AppConfig.$default$oauthCallbackPath();
            }
            String oauthCancellationUrl$value = this.oauthCancellationUrl$value;
            if (!this.oauthCancellationUrl$set) {
                oauthCancellationUrl$value = AppConfig.$default$oauthCancellationUrl();
            }
            String oauthCompletionUrl$value = this.oauthCompletionUrl$value;
            if (!this.oauthCompletionUrl$set) {
                oauthCompletionUrl$value = AppConfig.$default$oauthCompletionUrl();
            }
            return new AppConfig(slack$value, singleTeamBotToken$value, signingSecret$value, verificationToken$value, oAuthStartEnabled$value, oAuthCallbackEnabled$value, classicAppPermissionsEnabled$value, clientId$value, clientSecret$value, redirectUri$value, scope$value, userScope$value, this.appPath, oauthStartPath$value, oauthCallbackPath$value, oauthCancellationUrl$value, oauthCompletionUrl$value, this.alwaysRequestUserTokenNeeded);
        }

        public String toString() {
            return "AppConfig.AppConfigBuilder(slack$value=" + this.slack$value + ", singleTeamBotToken$value=" + this.singleTeamBotToken$value + ", signingSecret$value=" + this.signingSecret$value + ", verificationToken$value=" + this.verificationToken$value + ", oAuthStartEnabled$value=" + this.oAuthStartEnabled$value + ", oAuthCallbackEnabled$value=" + this.oAuthCallbackEnabled$value + ", classicAppPermissionsEnabled$value=" + this.classicAppPermissionsEnabled$value + ", clientId$value=" + this.clientId$value + ", clientSecret$value=" + this.clientSecret$value + ", redirectUri$value=" + this.redirectUri$value + ", scope$value=" + this.scope$value + ", userScope$value=" + this.userScope$value + ", appPath=" + this.appPath + ", oauthStartPath$value=" + this.oauthStartPath$value + ", oauthCallbackPath$value=" + this.oauthCallbackPath$value + ", oauthCancellationUrl$value=" + this.oauthCancellationUrl$value + ", oauthCompletionUrl$value=" + this.oauthCompletionUrl$value + ", alwaysRequestUserTokenNeeded=" + this.alwaysRequestUserTokenNeeded + ")";
        }
    }

    public static final class EnvVariableName {
        public static final String SLACK_BOT_TOKEN = "SLACK_BOT_TOKEN";
        public static final String SLACK_SIGNING_SECRET = "SLACK_SIGNING_SECRET";
        public static final String SLACK_VERIFICATION_TOKEN = "SLACK_VERIFICATION_TOKEN";
        public static final String SLACK_APP_CLIENT_ID = "SLACK_APP_CLIENT_ID";
        public static final String SLACK_APP_CLIENT_SECRET = "SLACK_APP_CLIENT_SECRET";
        public static final String SLACK_APP_REDIRECT_URI = "SLACK_APP_REDIRECT_URI";
        public static final String SLACK_APP_SCOPE = "SLACK_APP_SCOPE";
        public static final String SLACK_APP_USER_SCOPE = "SLACK_APP_USER_SCOPE";
        public static final String SLACK_APP_OAUTH_START_PATH = "SLACK_APP_OAUTH_START_PATH";
        public static final String SLACK_APP_OAUTH_CALLBACK_PATH = "SLACK_APP_OAUTH_CALLBACK_PATH";
        public static final String SLACK_APP_OAUTH_CANCELLATION_URL = "SLACK_APP_OAUTH_CANCELLATION_URL";
        public static final String SLACK_APP_OAUTH_COMPLETION_URL = "SLACK_APP_OAUTH_COMPLETION_URL";

        private EnvVariableName() {
        }
    }
}

