/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.slack.api.app_backend.views.payload.ViewSubmissionPayload;
import com.slack.api.bolt.context.builtin.ViewSubmissionContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;

public class ViewSubmissionRequest
extends Request<ViewSubmissionContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final ViewSubmissionPayload payload;
    private ViewSubmissionContext context = new ViewSubmissionContext();

    public ViewSubmissionRequest(String requestBody, String payloadBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (ViewSubmissionPayload)GsonFactory.createSnakeCase().fromJson(payloadBody, ViewSubmissionPayload.class);
        this.getContext().setEnterpriseId(this.payload.getTeam().getEnterpriseId());
        this.getContext().setTeamId(this.payload.getTeam().getId());
        this.getContext().setRequestUserId(this.payload.getUser().getId());
    }

    @Override
    public ViewSubmissionContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.ViewSubmission;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    public ViewSubmissionPayload getPayload() {
        return this.payload;
    }

    @Override
    public String toString() {
        return "ViewSubmissionRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

