/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.socket_mode;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.slack.api.SlackConfig;
import com.slack.api.bolt.App;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.socket_mode.request.SocketModeRequest;
import com.slack.api.bolt.socket_mode.request.SocketModeRequestParser;
import com.slack.api.socket_mode.SocketModeClient;
import com.slack.api.socket_mode.response.AckResponse;
import com.slack.api.socket_mode.response.SocketModeResponse;
import com.slack.api.util.json.GsonFactory;
import com.slack.api.util.thread.DaemonThreadExecutorServiceFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketModeApp {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SocketModeApp.class);
    private boolean clientStopped = true;
    private final App app;
    private final Supplier<SocketModeClient> clientFactory;
    private SocketModeClient client;
    private final ExecutorService executorService;
    private static final Function<ErrorContext, Response> DEFAULT_ERROR_HANDLER = context -> {
        Exception e = context.getException();
        log.error("Failed to handle a request: {}", (Object)e.getMessage(), (Object)e);
        return null;
    };

    private static void sendSocketModeResponse(SocketModeClient client, Gson gson, SocketModeRequest req, Response boltResponse) {
        if (boltResponse.getBody() != null) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (boltResponse.getContentType().startsWith("application/json")) {
                response.put("envelope_id", req.getEnvelope().getEnvelopeId());
                response.put("payload", gson.fromJson(boltResponse.getBody(), JsonElement.class));
            } else {
                response.put("envelope_id", req.getEnvelope().getEnvelopeId());
                HashMap<String, String> payload = new HashMap<String, String>();
                payload.put("text", boltResponse.getBody());
                response.put("payload", payload);
            }
            client.sendSocketModeResponse(gson.toJson(response));
        } else {
            client.sendSocketModeResponse((SocketModeResponse)new AckResponse(req.getEnvelope().getEnvelopeId()));
        }
    }

    private static Supplier<SocketModeClient> buildSocketModeClientFactory(App app, String appToken, SocketModeClient.Backend backend, Function<ErrorContext, Response> errorHandler, ExecutorService executorService) {
        return () -> {
            try {
                SocketModeClient client = app.slack().socketMode(appToken, backend);
                SocketModeRequestParser requestParser = new SocketModeRequestParser(app.config());
                Gson gson = GsonFactory.createSnakeCase((SlackConfig)app.slack().getConfig());
                client.addWebSocketMessageListener(message -> {
                    if (executorService != null) {
                        executorService.execute(() -> SocketModeApp.runBoltApp(message, app, client, requestParser, errorHandler, gson));
                    } else {
                        SocketModeApp.runBoltApp(message, app, client, requestParser, errorHandler, gson);
                    }
                });
                return client;
            }
            catch (IOException e) {
                log.error("Failed to start a new Socket Mode client (error: {})", (Object)e.getMessage(), (Object)e);
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runBoltApp(String message, App app, SocketModeClient client, SocketModeRequestParser requestParser, Function<ErrorContext, Response> errorHandler, Gson gson) {
        long startMillis = System.currentTimeMillis();
        SocketModeRequest req = requestParser.parse(message);
        if (req != null) {
            try {
                Response boltResponse = app.run(req.getBoltRequest());
                if (boltResponse.getStatusCode() != 200) {
                    log.warn("Unsuccessful Bolt app execution (status: {}, body: {})", (Object)boltResponse.getStatusCode(), (Object)boltResponse.getBody());
                    return;
                }
                SocketModeApp.sendSocketModeResponse(client, gson, req, boltResponse);
            }
            catch (Exception e) {
                ErrorContext context = ErrorContext.builder().request(req.getBoltRequest()).exception(e).build();
                Response errorResponse = errorHandler.apply(context);
                if (errorResponse != null) {
                    SocketModeApp.sendSocketModeResponse(client, gson, req, errorResponse);
                }
            }
            finally {
                long spentMillis = System.currentTimeMillis() - startMillis;
                log.debug("Response time: {} milliseconds", (Object)spentMillis);
            }
        }
    }

    private static ExecutorService buildExecutorService(int concurrency) {
        return DaemonThreadExecutorServiceFactory.createDaemonThreadPoolExecutor((String)"slack-bolt-socket-mode", (int)concurrency);
    }

    public SocketModeApp(App app) throws IOException {
        this(System.getenv("SLACK_APP_TOKEN"), SocketModeClient.Backend.Tyrus, app);
    }

    public SocketModeApp(App app, int concurrency) throws IOException {
        this(System.getenv("SLACK_APP_TOKEN"), app, SocketModeClient.Backend.Tyrus, concurrency);
    }

    public SocketModeApp(String appToken, App app) throws IOException {
        this(appToken, SocketModeClient.Backend.Tyrus, app);
    }

    public SocketModeApp(String appToken, App app, int concurrency) throws IOException {
        this(appToken, app, SocketModeClient.Backend.Tyrus, concurrency);
    }

    public SocketModeApp(String appToken, SocketModeClient.Backend backend, App app) throws IOException {
        this(appToken, backend, DEFAULT_ERROR_HANDLER, app);
    }

    public SocketModeApp(String appToken, App app, SocketModeClient.Backend backend) throws IOException {
        this(appToken, backend, DEFAULT_ERROR_HANDLER, app);
    }

    public SocketModeApp(String appToken, App app, SocketModeClient.Backend backend, int concurrency) throws IOException {
        this(appToken, backend, DEFAULT_ERROR_HANDLER, app, SocketModeApp.buildExecutorService(concurrency));
    }

    public SocketModeApp(String appToken, SocketModeClient.Backend backend, Function<ErrorContext, Response> errorHandler, App app) throws IOException {
        this(appToken, backend, errorHandler, app, null);
    }

    public SocketModeApp(String appToken, SocketModeClient.Backend backend, Function<ErrorContext, Response> errorHandler, App app, int concurrency) throws IOException {
        this(appToken, backend, errorHandler, app, SocketModeApp.buildExecutorService(concurrency));
    }

    public SocketModeApp(String appToken, App app, SocketModeClient.Backend backend, Function<ErrorContext, Response> errorHandler) throws IOException {
        this(appToken, backend, errorHandler, app, null);
    }

    public SocketModeApp(String appToken, App app, SocketModeClient.Backend backend, Function<ErrorContext, Response> errorHandler, int concurrency) throws IOException {
        this(appToken, backend, errorHandler, app, SocketModeApp.buildExecutorService(concurrency));
    }

    public SocketModeApp(Supplier<SocketModeClient> clientFactory, App app) {
        this(clientFactory, app, null);
    }

    private SocketModeApp(String appToken, SocketModeClient.Backend backend, Function<ErrorContext, Response> errorHandler, App app, ExecutorService executorService) throws IOException {
        this(SocketModeApp.buildSocketModeClientFactory(app, appToken, backend, errorHandler, executorService), app, executorService);
    }

    private SocketModeApp(Supplier<SocketModeClient> clientFactory, App app, ExecutorService executorService) {
        this.clientFactory = clientFactory;
        this.app = app;
        this.executorService = executorService;
    }

    public SocketModeApp(SocketModeClient socketModeClient, App app) {
        this.client = socketModeClient;
        this.clientFactory = () -> socketModeClient;
        this.app = app;
        this.executorService = null;
    }

    public void start() throws Exception {
        this.run(true);
    }

    public void startAsync() throws Exception {
        this.run(false);
    }

    public void run(boolean blockCurrentThread) throws Exception {
        this.app.start();
        if (this.client == null) {
            this.client = this.clientFactory.get();
        }
        if (this.isClientStopped()) {
            this.client.connectToNewEndpoint();
        } else {
            this.client.connect();
        }
        this.client.setAutoReconnectEnabled(true);
        this.clientStopped = false;
        if (blockCurrentThread) {
            Thread.sleep(Long.MAX_VALUE);
        }
    }

    public void stop() throws Exception {
        if (this.client != null && this.client.verifyConnection()) {
            this.client.disconnect();
        }
        this.clientStopped = true;
        this.app.stop();
    }

    public void close() throws Exception {
        this.stop();
        this.client = null;
        if (this.executorService != null) {
            for (Runnable runnable : this.executorService.shutdownNow()) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    log.warn("Failed to run the remaining Runnable in SocketModeApp (error: {}, message: {})", (Object)e.getClass().getCanonicalName(), (Object)e.getMessage());
                }
            }
        }
    }

    public boolean isClientStopped() {
        return this.clientStopped;
    }

    public SocketModeClient getClient() {
        return this.client;
    }

    public App getApp() {
        return this.app;
    }

    public static class ErrorContext {
        private Request<?> request;
        private Exception exception;

        @Generated
        ErrorContext(Request<?> request, Exception exception) {
            this.request = request;
            this.exception = exception;
        }

        @Generated
        public static ErrorContextBuilder builder() {
            return new ErrorContextBuilder();
        }

        @Generated
        public Request<?> getRequest() {
            return this.request;
        }

        @Generated
        public Exception getException() {
            return this.exception;
        }

        @Generated
        public void setRequest(Request<?> request) {
            this.request = request;
        }

        @Generated
        public void setException(Exception exception) {
            this.exception = exception;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorContext)) {
                return false;
            }
            ErrorContext other = (ErrorContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Request<?> this$request = this.getRequest();
            Request<?> other$request = other.getRequest();
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            Exception this$exception = this.getException();
            Exception other$exception = other.getException();
            return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ErrorContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Request<?> $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            Exception $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SocketModeApp.ErrorContext(request=" + this.getRequest() + ", exception=" + this.getException() + ")";
        }

        @Generated
        public static class ErrorContextBuilder {
            @Generated
            private Request<?> request;
            @Generated
            private Exception exception;

            @Generated
            ErrorContextBuilder() {
            }

            @Generated
            public ErrorContextBuilder request(Request<?> request) {
                this.request = request;
                return this;
            }

            @Generated
            public ErrorContextBuilder exception(Exception exception) {
                this.exception = exception;
                return this;
            }

            @Generated
            public ErrorContext build() {
                return new ErrorContext(this.request, this.exception);
            }

            @Generated
            public String toString() {
                return "SocketModeApp.ErrorContext.ErrorContextBuilder(request=" + this.request + ", exception=" + this.exception + ")";
            }
        }
    }
}

