/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.micronaut;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.SlackRequestParser;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.netty.NettyHttpResponseFactory;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Singleton
public class SlackAppMicronautAdapter {
    private SlackRequestParser requestParser;
    private NettyHttpResponseFactory micronautResponseFactory = new NettyHttpResponseFactory();

    public SlackAppMicronautAdapter(AppConfig appConfig) {
        this.requestParser = new SlackRequestParser(appConfig);
    }

    public Request<?> toSlackRequest(HttpRequest<?> req, String requestBody) {
        RequestHeaders headers = new RequestHeaders(req.getHeaders() != null ? req.getHeaders().asMap() : Collections.emptyMap());
        InetSocketAddress isa = req.getRemoteAddress();
        String remoteAddress = null;
        if (isa != null && isa.getAddress() != null) {
            remoteAddress = SlackAppMicronautAdapter.toString(isa.getAddress().getAddress());
        }
        SlackRequestParser.HttpRequest rawRequest = SlackRequestParser.HttpRequest.builder().requestUri(req.getPath()).queryString(req.getParameters() != null ? req.getParameters().asMap() : Collections.emptyMap()).headers(headers).requestBody(requestBody).remoteAddress(remoteAddress).build();
        return this.requestParser.parse(rawRequest);
    }

    public HttpResponse<String> toMicronautResponse(Response resp) {
        HttpStatus status = HttpStatus.valueOf((int)resp.getStatusCode());
        MutableHttpResponse response = this.micronautResponseFactory.status(status);
        for (Map.Entry header : resp.getHeaders().entrySet()) {
            String name = (String)header.getKey();
            for (String value : (List)header.getValue()) {
                response.header((CharSequence)name, (CharSequence)value);
            }
        }
        response.body((Object)resp.getBody());
        response.contentType((CharSequence)resp.getContentType());
        if (resp.getBody() != null) {
            response.contentLength((long)resp.getBody().length());
        } else {
            response.contentLength(0L);
        }
        return response;
    }

    private static final String toString(byte[] rawBytes) {
        int i = 4;
        StringBuilder ipAddress = new StringBuilder();
        for (byte raw : rawBytes) {
            ipAddress.append(raw & 0xFF);
            if (--i <= 0) continue;
            ipAddress.append(".");
        }
        return ipAddress.toString();
    }
}

