/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.http4k;

import com.slack.api.bolt.App;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.SlackRequestParser;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http4kSlackApp
implements Function1<Request, org.http4k.core.Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Http4kSlackApp.class);
    private final App app;
    private final SlackRequestParser requestParser;

    public Http4kSlackApp(App app) {
        this.app = app;
        this.requestParser = new SlackRequestParser(app.config());
    }

    public org.http4k.core.Response invoke(Request request) {
        try {
            return this.toHttp4kResponse(this.app.run(this.toSlackRequest(request)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return org.http4k.core.Response.Companion.create(Status.INTERNAL_SERVER_ERROR).header("Content-type", "application/json").body("{\"error\":\"An error occurred during processing of the request\"}");
        }
    }

    private com.slack.api.bolt.request.Request<?> toSlackRequest(Request httpRequest) {
        return this.requestParser.parse(SlackRequestParser.HttpRequest.builder().requestUri(httpRequest.getUri().getPath()).queryString(ParametersKt.toParameters((String)httpRequest.getUri().getQuery()).stream().collect(Collectors.toMap(Pair::component1, it -> Collections.singletonList((String)it.component2())))).requestBody(httpRequest.bodyString()).headers(new RequestHeaders(httpRequest.getHeaders().stream().collect(Collectors.toMap(Pair::component1, it -> Collections.singletonList((String)it.component2()))))).remoteAddress(httpRequest.header("X-Forwarded-For")).build());
    }

    private org.http4k.core.Response toHttp4kResponse(Response boltResponse) {
        Status status = new Status(boltResponse.getStatusCode().intValue(), "");
        List headers = boltResponse.getHeaders().entrySet().stream().flatMap(it -> ((List)it.getValue()).stream().map(it2 -> new Pair((Object)((String)it.getKey()), it2))).collect(Collectors.toList());
        String body = boltResponse.getBody();
        return org.http4k.core.Response.Companion.create(status).headers(headers).body(body == null ? "" : body);
    }
}

