/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.helidon;

import com.slack.api.bolt.App;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.SlackRequestParser;
import io.helidon.config.Config;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackAppService
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackAppService.class);
    private final Config config;
    private final App app;
    private final SlackRequestParser requestParser;

    public SlackAppService(Config config, App app) {
        this.config = config;
        this.app = app;
        this.requestParser = new SlackRequestParser(app.config());
    }

    public void update(Routing.Rules rules) {
        if (this.app.config().isDistributedApp()) {
            rules.get("/", new Handler[]{this::perform});
        }
        rules.post("/", new Handler[]{this::perform});
    }

    public void perform(ServerRequest request, ServerResponse response) {
        request.content().as(String.class).thenAccept(requestBody -> this.runSlackApp(request, (String)requestBody, response));
    }

    public void runSlackApp(ServerRequest request, String requestBody, ServerResponse response) {
        try {
            Request<?> slackRequest = this.buildSlackRequest(request, requestBody);
            Response slackResponse = this.app.run(slackRequest);
            this.writeToHelidonResponse(response, slackResponse);
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle a request (error: {})", (Object)e.getMessage(), (Object)e);
            response.status(500);
            response.headers().put("Content-Type", new String[]{"application/json"});
            response.send((Object)"{\"error\":\"Something is wrong\"}");
        }
    }

    public Request<?> buildSlackRequest(ServerRequest request, String requestBody) {
        String requestUri = request.uri() != null ? request.uri().getRawPath() : "/";
        Map query = request.queryParams() != null ? request.queryParams().toMap() : Collections.emptyMap();
        RequestHeaders headers = request.headers() != null ? new RequestHeaders(request.headers().toMap()) : new RequestHeaders(Collections.emptyMap());
        SlackRequestParser.HttpRequest httpRequest = SlackRequestParser.HttpRequest.builder().requestUri(requestUri).queryString(query).requestBody(requestBody).headers(headers).remoteAddress(request.remoteAddress()).build();
        return this.requestParser.parse(httpRequest);
    }

    public void writeToHelidonResponse(ServerResponse response, Response slackResponse) {
        response.status(slackResponse.getStatusCode().intValue());
        for (Map.Entry header : slackResponse.getHeaders().entrySet()) {
            response.headers().add((String)header.getKey(), (Iterable)header.getValue());
        }
        response.headers().put("Content-Type", new String[]{slackResponse.getContentType()});
        String body = slackResponse.getBody();
        if (body == null) {
            body = "";
        }
        response.send((Object)body);
    }
}

