/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.aws_lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.slack.api.bolt.App;
import com.slack.api.bolt.aws_lambda.request.ApiGatewayRequest;
import com.slack.api.bolt.aws_lambda.request.RequestContext;
import com.slack.api.bolt.aws_lambda.response.ApiGatewayResponse;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.util.SlackRequestParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SlackApiLambdaHandler
implements RequestHandler<ApiGatewayRequest, ApiGatewayResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackApiLambdaHandler.class);
    private final SlackRequestParser requestParser;
    private final App app;

    public SlackApiLambdaHandler(App app) {
        this.app = app;
        this.requestParser = new SlackRequestParser(app.config());
    }

    protected Request<?> toSlackRequest(ApiGatewayRequest awsReq) {
        if (log.isDebugEnabled()) {
            log.debug("AWS API Gateway Request: {}", (Object)awsReq);
        }
        RequestContext context = awsReq.getRequestContext();
        SlackRequestParser.HttpRequest rawRequest = SlackRequestParser.HttpRequest.builder().requestUri(awsReq.getPath()).queryString(SlackApiLambdaHandler.toStringToStringListMap(awsReq.getQueryStringParameters())).headers(new RequestHeaders(SlackApiLambdaHandler.toStringToStringListMap(awsReq.getHeaders()))).requestBody(awsReq.getBody()).remoteAddress(context != null && context.getIdentity() != null ? context.getIdentity().getSourceIp() : null).build();
        return this.requestParser.parse(rawRequest);
    }

    protected ApiGatewayResponse toApiGatewayResponse(Response slackResp) {
        return ApiGatewayResponse.builder().statusCode(slackResp.getStatusCode()).headers(SlackApiLambdaHandler.toStringToStringMap(slackResp.getHeaders())).rawBody(slackResp.getBody()).build();
    }

    protected abstract boolean isWarmupRequest(ApiGatewayRequest var1);

    public ApiGatewayResponse handleRequest(ApiGatewayRequest input, Context context) {
        if (this.isWarmupRequest(input)) {
            this.app.start();
            log.info("Successfully responded to a warmup request ({})", (Object)input);
            return null;
        }
        Request<?> req = this.toSlackRequest(input);
        try {
            if (req == null) {
                return ApiGatewayResponse.builder().statusCode(400).rawBody("Invalid Request").build();
            }
            return this.toApiGatewayResponse(this.app.run(req));
        }
        catch (Exception e) {
            log.error("Failed to respond to a request (request: {}, error: {})", new Object[]{input.getBody(), e.getMessage(), e});
            return ApiGatewayResponse.builder().statusCode(500).rawBody("Internal Server Error").build();
        }
    }

    private static Map<String, String> toStringToStringMap(Map<String, List<String>> stringToStringListMap) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> each : stringToStringListMap.entrySet()) {
            if (each.getValue() == null || each.getValue().size() <= 0) continue;
            headers.put(each.getKey(), each.getValue().get(0));
        }
        return headers;
    }

    private static Map<String, List<String>> toStringToStringListMap(Map<String, String> stringToStringListMap) {
        if (stringToStringListMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> each : stringToStringListMap.entrySet()) {
            results.put(each.getKey(), Arrays.asList(each.getValue()));
        }
        return results;
    }
}

