/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.services.rds.auth.GetIamAuthTokenRequest;
import com.amazonaws.services.rds.auth.RdsIamAuthTokenGenerator;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.plugin.credential.Credential;
import java.util.Properties;

public class AwsCredentialGenerator {
    private final RdsIamAuthTokenGenerator generator;
    private final GetIamAuthTokenRequest request;
    private final String userName;

    public AwsCredentialGenerator(Properties nonMappedOptions, String userName, HostAddress hostAddress) {
        this.userName = userName;
        String accessKeyId = nonMappedOptions.getProperty("accessKeyId");
        String secretKey = nonMappedOptions.getProperty("secretKey");
        String region = nonMappedOptions.getProperty("region");
        Object awsCredentialsProvider = accessKeyId != null && secretKey != null ? new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKeyId, secretKey)) : new DefaultAWSCredentialsProviderChain();
        this.generator = RdsIamAuthTokenGenerator.builder().credentials((AWSCredentialsProvider)awsCredentialsProvider).region(region != null ? region : new DefaultAwsRegionProviderChain().getRegion()).build();
        this.request = GetIamAuthTokenRequest.builder().hostname(hostAddress.host).port(hostAddress.port).userName(userName).build();
    }

    public Credential getToken() {
        return new Credential(this.userName, this.generator.getAuthToken(this.request));
    }
}

