/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd.trans;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.trans.Transition;
import com.simsilica.mathd.trans.TransitionBuffer;

public class PositionTransition3f
implements Transition<PositionTransition3f> {
    private long startTime;
    private Vector3f startPos;
    private Quaternion startRot;
    private boolean startVisible;
    private final long endTime;
    private final Vector3f endPos;
    private final Quaternion endRot;
    private final boolean endVisible;

    public PositionTransition3f(long endTime, Vector3f endPos, Quaternion endRot, boolean visible) {
        this.endTime = endTime;
        this.endPos = endPos;
        this.endRot = endRot;
        this.endVisible = visible;
    }

    public PositionTransition3f(long endTime, Vec3d endPos, Quatd endRot, boolean visible) {
        this.endTime = endTime;
        this.endPos = new Vector3f((float)endPos.x, (float)endPos.y, (float)endPos.z);
        this.endRot = new Quaternion((float)endRot.x, (float)endRot.y, (float)endRot.z, (float)endRot.w);
        this.endVisible = visible;
    }

    public static TransitionBuffer<PositionTransition3f> createBuffer(int history) {
        return new TransitionBuffer<PositionTransition3f>(history);
    }

    @Override
    public void setPreviousTransition(PositionTransition3f previous) {
        this.startTime = previous.endTime;
        this.startPos = previous.endPos;
        this.startRot = previous.endRot;
        this.startVisible = previous.endVisible;
        if (this.startTime > this.endTime) {
            throw new IllegalArgumentException("Frame transitions cannot go backwards.");
        }
    }

    @Override
    public boolean containsTime(long time) {
        if (time < this.startTime) {
            return false;
        }
        return time <= this.endTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    protected final float tween(long time) {
        long length = this.endTime - this.startTime;
        if (length == 0L) {
            return 0.0f;
        }
        float part = time - this.startTime;
        if (part > (float)length) {
            return 1.0f;
        }
        if (part < 0.0f) {
            return 0.0f;
        }
        return part / (float)length;
    }

    public Vector3f getPosition(long time) {
        return this.getPosition(time, false);
    }

    public Vector3f getPosition(long time, boolean clamp) {
        if (this.startPos == null) {
            return clamp ? this.endPos.clone() : null;
        }
        if (time < this.startTime) {
            return clamp ? this.startPos.clone() : null;
        }
        float t = this.tween(time);
        Vector3f result = new Vector3f().interpolateLocal(this.startPos, this.endPos, t);
        return result;
    }

    public Quaternion getRotation(long time) {
        return this.getRotation(time, false);
    }

    public Quaternion getRotation(long time, boolean clamp) {
        if (this.startRot == null) {
            return clamp ? this.endRot.clone() : null;
        }
        if (time < this.startTime) {
            return clamp ? this.startRot.clone() : null;
        }
        Quaternion result = new Quaternion().slerp(this.startRot, this.endRot, this.tween(time));
        return result;
    }

    public boolean getVisibility(long time) {
        if (time > this.endTime) {
            return this.endVisible;
        }
        return this.startVisible;
    }

    public Vector3f getStartPosition() {
        return this.startPos;
    }

    public Vector3f getEndPosition() {
        return this.endPos;
    }

    public Quaternion getStartRotation() {
        return this.startRot;
    }

    public Quaternion getEndRotation() {
        return this.endRot;
    }

    public boolean getStartVisibility() {
        return this.startVisible;
    }

    public boolean getEndVisibility() {
        return this.endVisible;
    }

    public String toString() {
        return "PositionTransition3f[ t:" + this.startTime + ", pos:" + this.startPos + ", rot:" + this.startRot + ", vis:" + this.startVisible + " -> t:" + this.endTime + ", pos:" + this.endPos + ", rot:" + this.endRot + ", vis:" + this.endVisible + " ]";
    }
}

