/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import java.io.Serializable;

public class Vec3i
implements Cloneable,
Serializable {
    static final long serialVersionUID = 42L;
    public int x;
    public int y;
    public int z;

    public Vec3i() {
    }

    public Vec3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3i(Vector3f v) {
        this((int)v.x, (int)v.y, (int)v.z);
    }

    public Vec3i(Vec3i v) {
        this(v.x, v.y, v.z);
    }

    public Vector3f toVector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public Vec3d toVec3d() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Vec3i other = (Vec3i)o;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        int hash = 37;
        hash += 37 * hash + this.x;
        hash += 37 * hash + this.y;
        hash += 37 * hash + this.z;
        return hash;
    }

    public Vec3i clone() {
        try {
            return (Vec3i)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning", e);
        }
    }

    public final Vec3i set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public final Vec3i set(Vec3i val) {
        this.x = val.x;
        this.y = val.y;
        this.z = val.z;
        return this;
    }

    public final int get(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    public final Vec3i set(int index, int value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
        }
        return this;
    }

    public final Vec3i addLocal(Vec3i v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public final Vec3i addLocal(int i, int j, int k) {
        this.x += i;
        this.y += j;
        this.z += k;
        return this;
    }

    public final Vec3i subtractLocal(Vec3i v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public final Vec3i subtractLocal(int i, int j, int k) {
        this.x -= i;
        this.y -= j;
        this.z -= k;
        return this;
    }

    public final Vec3i add(int i, int j, int k) {
        return new Vec3i(this.x + i, this.y + j, this.z + k);
    }

    public final Vec3i add(Vec3i v) {
        return new Vec3i(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public final Vec3i subtract(Vec3i v) {
        return new Vec3i(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public final Vec3i subtract(int vx, int vy, int vz) {
        return new Vec3i(this.x - vx, this.y - vy, this.z - vz);
    }

    public final Vec3i mult(int scale) {
        return new Vec3i(this.x * scale, this.y * scale, this.z * scale);
    }

    public final int getDistanceSq(Vec3i v) {
        int xd = v.x - this.x;
        int yd = v.y - this.y;
        int zd = v.z - this.z;
        return xd * xd + yd * yd + zd * zd;
    }

    public final double getDistance(Vec3i v) {
        return Math.sqrt(this.getDistanceSq(v));
    }

    public final double lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSq());
    }

    public Vec3i minLocal(int i, int j, int k) {
        this.x = Math.min(this.x, i);
        this.y = Math.min(this.y, j);
        this.z = Math.min(this.z, k);
        return this;
    }

    public Vec3i maxLocal(int i, int j, int k) {
        this.x = Math.max(this.x, i);
        this.y = Math.max(this.y, j);
        this.z = Math.max(this.z, k);
        return this;
    }

    public Vec3i minLocal(Vec3i v) {
        this.x = Math.min(v.x, this.x);
        this.y = Math.min(v.y, this.y);
        this.z = Math.min(v.z, this.z);
        return this;
    }

    public Vec3i maxLocal(Vec3i v) {
        this.x = Math.max(v.x, this.x);
        this.y = Math.max(v.y, this.y);
        this.z = Math.max(v.z, this.z);
        return this;
    }

    public String toDisplay() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public String toString() {
        return "Vec3i[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

