/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.io.Serializable;

public class Grid
implements Serializable {
    static final long serialVersionUID = 42L;
    private final Vec3i gridSpacing;
    private final int dimensions;
    private final int shift;
    private final long mask;
    private final int signCheck;
    private final int signExtend;

    public Grid(int spacing) {
        this(spacing, spacing, spacing);
    }

    public Grid(int xSpacing, int zSpacing) {
        this(xSpacing, 0, zSpacing);
    }

    public Grid(int xSpacing, int ySpacing, int zSpacing) {
        this(new Vec3i(xSpacing, ySpacing, zSpacing));
    }

    public Grid(Vec3i gridSpacing) {
        int bits;
        this.gridSpacing = gridSpacing;
        int axes = 0;
        if (gridSpacing.x != 0) {
            ++axes;
        }
        if (gridSpacing.y != 0) {
            ++axes;
        }
        if (gridSpacing.z != 0) {
            ++axes;
        }
        this.dimensions = axes;
        this.shift = bits = 64 / axes;
        this.signExtend = (int)(-1L << bits);
        this.signCheck = 1 << bits - 1;
        this.mask = -1L << bits ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final Vec3i getSpacing() {
        return this.gridSpacing;
    }

    public final int getDimensions() {
        return this.dimensions;
    }

    private int worldToCell(int i, int size) {
        if (size == 0) {
            return 0;
        }
        if (i < 0) {
            i = (i + 1) / size;
            return i - 1;
        }
        return i / size;
    }

    private int worldToCell(double d, int size) {
        return this.worldToCell((int)Math.floor(d), size);
    }

    private int cellToWorld(int i, int size) {
        return i * size;
    }

    public final GridCell getContainingCell(double xWorld, double yWorld, double zWorld) {
        return new GridCell(this, this.worldToCell(xWorld, yWorld, zWorld));
    }

    public final GridCell getContainingCell(Vec3d world) {
        return this.getContainingCell(world.x, world.y, world.z);
    }

    public final GridCell getContainingCell(Vec3i world) {
        return this.getContainingCell(world.x, world.y, world.z);
    }

    public final GridCell getGridCell(Vec3i cell) {
        return new GridCell(this, cell.clone());
    }

    public final GridCell getGridCell(int xCell, int yCell, int zCell) {
        return new GridCell(this, new Vec3i(xCell, yCell, zCell));
    }

    public final Vec3i worldToCell(double xWorld, double yWorld, double zWorld) {
        return this.worldToCell(xWorld, yWorld, zWorld, new Vec3i());
    }

    public final Vec3i worldToCell(double xWorld, double yWorld, double zWorld, Vec3i store) {
        if (store == null) {
            store = new Vec3i();
        }
        store.x = this.worldToCell(xWorld, this.gridSpacing.x);
        store.y = this.worldToCell(yWorld, this.gridSpacing.y);
        store.z = this.worldToCell(zWorld, this.gridSpacing.z);
        return store;
    }

    public final Vec3i worldToCell(Vec3d world) {
        return this.worldToCell(world.x, world.y, world.z, new Vec3i());
    }

    public final Vec3i worldToCell(Vec3d world, Vec3i store) {
        return this.worldToCell(world.x, world.y, world.z, store);
    }

    public final Vec3i cellToWorld(int xCell, int yCell, int zCell) {
        return this.cellToWorld(xCell, yCell, zCell, new Vec3i());
    }

    public final Vec3i cellToWorld(int xCell, int yCell, int zCell, Vec3i store) {
        if (store == null) {
            store = new Vec3i();
        }
        store.x = this.cellToWorld(xCell, this.gridSpacing.x);
        store.y = this.cellToWorld(yCell, this.gridSpacing.y);
        store.z = this.cellToWorld(zCell, this.gridSpacing.z);
        return store;
    }

    public final Vec3d cellToWorld(int xCell, int yCell, int zCell, Vec3d store) {
        if (store == null) {
            store = new Vec3d();
        }
        store.x = this.cellToWorld(xCell, this.gridSpacing.x);
        store.y = this.cellToWorld(yCell, this.gridSpacing.y);
        store.z = this.cellToWorld(zCell, this.gridSpacing.z);
        return store;
    }

    public final Vec3i cellToWorld(Vec3i cell) {
        return this.cellToWorld(cell.x, cell.y, cell.z, new Vec3i());
    }

    public final Vec3i cellToWorld(Vec3i cell, Vec3i store) {
        return this.cellToWorld(cell.x, cell.y, cell.z, store);
    }

    public final Vec3d cellToWorld(Vec3i cell, Vec3d store) {
        return this.cellToWorld(cell.x, cell.y, cell.z, store);
    }

    public final long worldToId(Vec3d world) {
        return this.worldToId(world.x, world.y, world.z);
    }

    public final long worldToId(double xWorld, double yWorld, double zWorld) {
        int x = this.worldToCell(xWorld, this.gridSpacing.x);
        int y = this.worldToCell(yWorld, this.gridSpacing.y);
        int z = this.worldToCell(zWorld, this.gridSpacing.z);
        return this.cellToId(x, y, z);
    }

    public final long cellToId(Vec3i cell) {
        return this.cellToId(cell.x, cell.y, cell.z);
    }

    public final long cellToId(int xCell, int yCell, int zCell) {
        long result = 0L;
        int nextShift = 0;
        if (this.gridSpacing.x != 0) {
            result = (long)xCell & this.mask;
            nextShift = this.shift;
        }
        if (this.gridSpacing.y != 0) {
            result = result << nextShift | (long)yCell & this.mask;
            nextShift = this.shift;
        }
        if (this.gridSpacing.z != 0) {
            result = result << nextShift | (long)zCell & this.mask;
        }
        return result;
    }

    public final Vec3i idToCell(long id, Vec3i store) {
        int x;
        int y;
        int z;
        if (this.gridSpacing.z != 0) {
            z = (int)(id & this.mask);
            if ((z & this.signCheck) != 0) {
                z |= this.signExtend;
            }
            id >>= this.shift;
        } else {
            z = 0;
        }
        if (this.gridSpacing.y != 0) {
            y = (int)(id & this.mask);
            if ((y & this.signCheck) != 0) {
                y |= this.signExtend;
            }
            id >>= this.shift;
        } else {
            y = 0;
        }
        if (this.gridSpacing.x != 0) {
            x = (int)(id & this.mask);
            if ((x & this.signCheck) != 0) {
                x |= this.signExtend;
            }
            id >>= this.shift;
        } else {
            x = 0;
        }
        if (store == null) {
            store = new Vec3i(x, y, z);
        } else {
            store.set(x, y, z);
        }
        return store;
    }

    public final Vec3i idToCell(long id) {
        return this.idToCell(id, new Vec3i());
    }

    public String toString() {
        return "Grid[" + this.gridSpacing + "]";
    }
}

