/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.phase_prebuild;

import com.simpligility.maven.plugins.android.common.AndroidExtension;
import com.simpligility.maven.plugins.android.common.ArtifactResolverHelper;
import com.simpligility.maven.plugins.android.common.DependencyResolver;
import com.simpligility.maven.plugins.android.common.PomConfigurationHelper;
import com.simpligility.maven.plugins.android.common.UnpackedLibHelper;
import com.simpligility.maven.plugins.android.phase_prebuild.ProvidedDependencyChecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="default")
public final class ClasspathModifierLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String INCLUDE_FROM_APKLIB_PARAM = "includeLibsJarsFromApklib";
    private static final String INCLUDE_FROM_AAR_PARAM = "includeLibsJarsFromAar";
    private static final String DISABLE_CONFLICTING_DEPENDENCIES_WARNING_PARAM = "disableConflictingDependenciesWarning";
    private static final boolean INCLUDE_FROM_APKLIB_DEFAULT = false;
    private static final boolean INCLUDE_FROM_AAR_DEFAULT = true;
    private static final boolean DISABLE_CONFLICTING_DEPENDENCIES_WARNING_DEFAULT = false;
    private static final String UNPACKED_LIBS_FOLDER_PARAM = "unpackedLibsFolder";
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Requirement
    private Logger log;
    private boolean addedJarFromLibs = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.log.debug("");
        this.log.debug("ClasspathModifierLifecycleParticipant#afterProjectsRead - start");
        this.log.debug("");
        this.log.debug("CurrentProject=" + session.getCurrentProject());
        List projects = session.getProjects();
        DependencyResolver dependencyResolver = new DependencyResolver(this.log, this.dependencyGraphBuilder);
        ArtifactResolverHelper artifactResolverHelper = new ArtifactResolverHelper(this.artifactResolver, this.log);
        for (MavenProject project : projects) {
            Set<Artifact> artifacts;
            this.log.debug("");
            this.log.debug("project=" + project.getArtifact());
            if (!AndroidExtension.isAndroidPackaging(project.getPackaging())) continue;
            String unpackedLibsFolder = this.getMojoConfigurationParameter(project, UNPACKED_LIBS_FOLDER_PARAM, null);
            UnpackedLibHelper helper = new UnpackedLibHelper(artifactResolverHelper, project, this.log, unpackedLibsFolder == null ? null : new File(unpackedLibsFolder));
            Object projectClassLoader = project.getClassRealm() != null ? project.getClassRealm() : Thread.currentThread().getContextClassLoader();
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)projectClassLoader);
                artifacts = dependencyResolver.getProjectDependenciesFor(project, session);
            }
            catch (DependencyGraphBuilderException e) {}
            continue;
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                continue;
            }
            boolean includeFromAar = this.getMojoConfigurationParameter(project, INCLUDE_FROM_AAR_PARAM, true);
            boolean includeFromApklib = this.getMojoConfigurationParameter(project, INCLUDE_FROM_APKLIB_PARAM, false);
            boolean disableConflictingDependenciesWarning = this.getMojoConfigurationParameter(project, DISABLE_CONFLICTING_DEPENDENCIES_WARNING_PARAM, false);
            this.log.debug("projects deps: : " + artifacts);
            if (!disableConflictingDependenciesWarning) {
                ProvidedDependencyChecker checker = new ProvidedDependencyChecker();
                checker.checkProvidedDependencies(artifacts, this.log);
            }
            for (Artifact artifact : artifacts) {
                String type = artifact.getType();
                if (type.equals("aar")) {
                    this.addClassesToClasspath(helper, project, artifact);
                    if (!includeFromAar) continue;
                    this.addLibsJarsToClassPath(helper, project, artifact);
                    continue;
                }
                if (type.equals("apk")) {
                    this.addClassesToClasspath(helper, project, artifact);
                    continue;
                }
                if (!type.equals("apklib") || !includeFromApklib) continue;
                this.addLibsJarsToClassPath(helper, project, artifact);
            }
        }
        if (this.addedJarFromLibs) {
            this.log.warn("Transitive dependencies should really be provided by Maven dependency management.\n          We suggest you to ask the above providers to package their component properly.\n          Things may break at compile and/or runtime due to multiple copies of incompatible libraries.");
        }
        this.log.debug("");
        this.log.debug("ClasspathModifierLifecycleParticipant#afterProjectsRead - finish");
    }

    private String getMojoConfigurationParameter(MavenProject project, String name, String defaultValue) {
        String value = PomConfigurationHelper.getPluginConfigParameter(project, name, defaultValue);
        this.log.debug(name + " set to " + value);
        return value;
    }

    private boolean getMojoConfigurationParameter(MavenProject project, String name, boolean defaultValue) {
        return Boolean.valueOf(this.getMojoConfigurationParameter(project, name, Boolean.toString(defaultValue)));
    }

    private void addLibsJarsToClassPath(UnpackedLibHelper helper, MavenProject project, Artifact artifact) throws MavenExecutionException {
        try {
            File unpackLibFolder = helper.getUnpackedLibFolder(artifact);
            File artifactFile = helper.getArtifactToFile(artifact);
            ZipFile zipFile = new ZipFile(artifactFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                String entryName = entry.getName();
                if (!Pattern.matches("^libs/.+\\.jar$", entryName)) continue;
                File libsJarFile = new File(unpackLibFolder, entryName);
                this.log.warn("Adding jar from libs folder to classpath: " + libsJarFile);
                if (!libsJarFile.getParentFile().exists()) {
                    libsJarFile.getParentFile().mkdirs();
                }
                libsJarFile.createNewFile();
                Dependency dependency = this.createSystemScopeDependency(artifact, libsJarFile, libsJarFile.getName());
                project.getModel().addDependency(dependency);
                this.addedJarFromLibs = true;
            }
        }
        catch (MojoExecutionException e) {
            this.log.debug("Error extract jars");
        }
        catch (ZipException e) {
            this.log.debug("Error");
        }
        catch (IOException e) {
            this.log.debug("Error");
        }
    }

    private void addClassesToClasspath(UnpackedLibHelper helper, MavenProject project, Artifact artifact) throws MavenExecutionException {
        Dependency dependency;
        Dependency providedJar;
        File classesJar = helper.getUnpackedClassesJar(artifact);
        this.log.debug("Adding to classpath : " + classesJar);
        if (!classesJar.exists()) {
            classesJar.getParentFile().mkdirs();
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(classesJar));
                zipOutputStream.putNextEntry(new ZipEntry("dummy"));
                zipOutputStream.close();
                this.log.debug("Created dummy " + classesJar.getName() + " exist=" + classesJar.exists());
            }
            catch (IOException e) {
                throw new MavenExecutionException("Could not add " + classesJar.getName() + " as dependency", (Throwable)e);
            }
        }
        if ((providedJar = this.findProvidedDependencies(dependency = this.createSystemScopeDependency(artifact, classesJar, null), project)) != null) {
            project.getModel().removeDependency(providedJar);
        }
        project.getModel().addDependency(dependency);
    }

    private Dependency createSystemScopeDependency(Artifact artifact, File location, String suffix) {
        String artifactId = artifact.getArtifactId();
        if (suffix != null) {
            artifactId = artifactId + "_" + suffix;
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifactId);
        dependency.setVersion(artifact.getBaseVersion());
        dependency.setScope("system");
        dependency.setSystemPath(location.getAbsolutePath());
        return dependency;
    }

    private Dependency findProvidedDependencies(Dependency dexDependency, MavenProject project) {
        for (Dependency dependency : project.getDependencies()) {
            if (!dependency.getScope().equals("provided") || !dependency.getArtifactId().equals(dexDependency.getArtifactId()) || !dependency.getGroupId().equals(dexDependency.getGroupId()) || !dependency.getType().equals(dexDependency.getType()) || !dependency.getVersion().equals(dexDependency.getVersion())) continue;
            return dependency;
        }
        return null;
    }
}

