/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;

public class InclusionExclusionResolver {
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final Function<String, String> TRIMMER = new Function<String, String>(){

        public String apply(String value) {
            return value.trim();
        }
    };
    private static final Predicate<String> MUST_NOT_BE_BLANK = new Predicate<String>(){

        public boolean apply(String value) {
            return !value.trim().isEmpty();
        }
    };

    private InclusionExclusionResolver() {
    }

    public static Collection<Artifact> filterArtifacts(Iterable<Artifact> artifacts, final boolean skipDependencies, final Collection<String> includeArtifactTypes, final Collection<String> excludeArtifactTypes, final Collection<String> includeArtifactQualifiers, final Collection<String> excludeArtifactQualifiers) {
        final boolean hasIncludeTypes = includeArtifactTypes != null;
        final boolean hasExcludeTypes = excludeArtifactTypes != null;
        final boolean hasIncludeQualifier = includeArtifactQualifiers != null;
        final boolean hasExcludeQualifier = excludeArtifactQualifiers != null;
        return FluentIterable.from(artifacts).filter((Predicate)new Predicate<Artifact>(){

            public boolean apply(Artifact artifact) {
                boolean excludedByQualifier;
                boolean includedByType = hasIncludeTypes && includeArtifactTypes.contains(artifact.getType());
                boolean includedByQualifier = hasIncludeQualifier && InclusionExclusionResolver.match(artifact, includeArtifactQualifiers);
                boolean excludedByType = hasExcludeTypes && excludeArtifactTypes.contains(artifact.getType());
                boolean bl = excludedByQualifier = hasExcludeQualifier && InclusionExclusionResolver.match(artifact, excludeArtifactQualifiers);
                if (!skipDependencies) {
                    return !excludedByType && !excludedByQualifier || includedByQualifier || includedByType && !excludedByQualifier;
                }
                return includedByQualifier || includedByType && hasExcludeQualifier && !excludedByQualifier || includedByType;
            }
        }).toSet();
    }

    private static boolean match(final Artifact artifact, Iterable<String> artifactQualifiers) {
        return FluentIterable.from(artifactQualifiers).filter(MUST_NOT_BE_BLANK).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String artifactQualifier) {
                return InclusionExclusionResolver.match(artifact, artifactQualifier);
            }
        });
    }

    private static boolean match(Artifact artifact, String artifactQualifier) {
        ImmutableList split = FluentIterable.from((Iterable)COLON_SPLITTER.split((CharSequence)artifactQualifier)).transform(TRIMMER).toList();
        int count = split.size();
        if (split.isEmpty() || count > 3) {
            throw new IllegalArgumentException("Invalid artifact qualifier: " + artifactQualifier);
        }
        String groupId = (String)split.get(0);
        if (!groupId.equals(artifact.getGroupId())) {
            return false;
        }
        if (count == 1) {
            return true;
        }
        String artifactId = (String)split.get(1);
        if (!artifactId.equals(artifact.getArtifactId())) {
            return false;
        }
        if (count == 2) {
            return true;
        }
        String version = (String)split.get(2);
        return version.equals(artifact.getVersion());
    }
}

