/*
 * Decompiled with CFR 0.152.
 */
package com.silverforge.controls;

import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.silverforge.controls.BusyIndicator;

public class LoaderAngleAnimation
extends Animation {
    private BusyIndicator busyIndicator;
    private float newAngle;
    private float oldAngle;

    public LoaderAngleAnimation(BusyIndicator busyIndicator, float newAngle) {
        this.busyIndicator = busyIndicator;
        this.newAngle = newAngle;
        this.oldAngle = busyIndicator.getArcAngle();
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        super.applyTransformation(interpolatedTime, t);
        float angle = this.oldAngle + (this.newAngle - this.oldAngle) * interpolatedTime;
        this.busyIndicator.setArcAngle(angle);
        this.busyIndicator.requestLayout();
    }
}

