/*
 * Decompiled with CFR 0.152.
 */
package com.silverforge.controls.calculators;

import com.silverforge.controls.model.PositionSettings;

public class CoordinateCalculator {
    public PositionSettings calculateBasePositions(int width, int height, int paddingLeft, int paddingTop) {
        PositionSettings positionSettings = new PositionSettings();
        float bigRadius = height > width ? (float)(width / 2) : (float)(height / 2);
        bigRadius = (float)((double)bigRadius * 0.8);
        float bigPointRadius = (float)((double)bigRadius * 0.15);
        float layoutCenterX = paddingLeft + width / 2;
        float layoutCenterY = paddingTop + height / 2;
        float singleRadius = (float)((double)bigRadius * 0.75);
        float singlePointRadius = (float)((double)singleRadius * 0.05);
        positionSettings.setWidth(width);
        positionSettings.setHeight(height);
        positionSettings.setPaddingLeft(paddingLeft);
        positionSettings.setPaddingTop(paddingTop);
        positionSettings.setLayOutCenterX(layoutCenterX);
        positionSettings.setLayOutCenterY(layoutCenterY);
        positionSettings.setBigRadius(bigRadius);
        positionSettings.setBigPointRadius(bigPointRadius);
        positionSettings.setSingleRadius(singleRadius);
        positionSettings.setSinglePointRadius(singlePointRadius);
        return positionSettings;
    }

    public static float getYCoordinate(float angleInDegrees, float layoutCenterY, float radius) {
        return (float)((double)radius * Math.sin((double)angleInDegrees * Math.PI / 180.0) + (double)layoutCenterY);
    }

    public static float getXCoordinate(float angleInDegrees, float layoutCenterX, float radius) {
        return (float)((double)radius * Math.cos((double)angleInDegrees * Math.PI / 180.0) + (double)layoutCenterX);
    }
}

