/*
 * Decompiled with CFR 0.152.
 */
package com.silverforge.controls;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import com.silverforge.controls.model.ClipShape;
import com.silverforge.controls.model.ConfigSettings;
import com.silverforge.library.R;
import java.util.HashMap;
import java.util.Map;

class Indicator
extends View {
    protected final Map<Integer, String> decimalPlacesMap = new HashMap<Integer, String>();
    protected ConfigSettings configSettings;

    public Indicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.configSettings = this.readAttributes(context, attrs, defStyleAttr);
        this.initializeMembers();
    }

    private void initializeMembers() {
        this.decimalPlacesMap.put(0, "%.0f%%");
        this.decimalPlacesMap.put(1, "%.1f%%");
        this.decimalPlacesMap.put(2, "%.2f%%");
    }

    private ConfigSettings readAttributes(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BusyIndicator, defStyleAttr, 0);
        ConfigSettings configSettings = this.readAttributeValues(attributes);
        attributes.recycle();
        return configSettings;
    }

    private ConfigSettings readAttributeValues(TypedArray attributes) {
        float strokeWidthMultiplier;
        int angleModifier;
        ConfigSettings configSettings = new ConfigSettings();
        boolean isBackgroundVisible = attributes.getBoolean(R.styleable.BusyIndicator_background_is_visible, false);
        int backgroundColor = attributes.getColor(R.styleable.BusyIndicator_background_color, Color.argb((int)100, (int)200, (int)200, (int)200));
        boolean isPercentageVisible = attributes.getBoolean(R.styleable.BusyIndicator_percentage_is_visible, true);
        int clipShapeIndex = attributes.getInteger(R.styleable.BusyIndicator_background_shape, ClipShape.ROUNDED_RECTANGLE.getIndex());
        ClipShape backgroundShape = ClipShape.values()[clipShapeIndex];
        int bigPointCount = attributes.getInteger(R.styleable.BusyIndicator_bigpoint_count, 12);
        if (bigPointCount < 4) {
            bigPointCount = 4;
        }
        if (bigPointCount > 20) {
            bigPointCount = 20;
        }
        int smallPointColor = attributes.getColor(R.styleable.BusyIndicator_smallpoint_color, -16777216);
        int bigPointColor = attributes.getColor(R.styleable.BusyIndicator_bigpoint_color, -12303292);
        boolean infinite = attributes.getBoolean(R.styleable.BusyIndicator_infinite, true);
        float maxValue = attributes.getFloat(R.styleable.BusyIndicator_max_value, 100.0f);
        int decimalPlaces = attributes.getInt(R.styleable.BusyIndicator_percentage_decimal_places, 0);
        if (decimalPlaces > 2) {
            decimalPlaces = 2;
        }
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if ((angleModifier = attributes.getInt(R.styleable.BusyIndicator_angle_modifier, 1)) > 3) {
            angleModifier = 3;
        }
        if (angleModifier < 1) {
            angleModifier = 1;
        }
        if ((double)(strokeWidthMultiplier = attributes.getFloat(R.styleable.BusyIndicator_stroke_width_multiplier, 6.0f)) < 0.2) {
            strokeWidthMultiplier = 0.2f;
        }
        if (strokeWidthMultiplier > 14.0f) {
            strokeWidthMultiplier = 14.0f;
        }
        boolean loadPointsAreVisible = attributes.getBoolean(R.styleable.BusyIndicator_load_points_are_visible, true);
        int indicatorAlpha = attributes.getInt(R.styleable.BusyIndicator_indicator_alpha, 100);
        if (indicatorAlpha < 100) {
            indicatorAlpha = 100;
        }
        if (indicatorAlpha > 255) {
            indicatorAlpha = 255;
        }
        configSettings.setBackgroundColor(backgroundColor);
        configSettings.setBackgroundShape(backgroundShape);
        configSettings.setBackgroundVisible(isBackgroundVisible);
        configSettings.setBigPointColor(bigPointColor);
        configSettings.setBigPointCount(bigPointCount);
        configSettings.setSmallPointColor(smallPointColor);
        configSettings.setPercentageVisible(isPercentageVisible);
        configSettings.setPercentageDecimalPlaces(decimalPlaces);
        configSettings.setMaxValue(maxValue);
        configSettings.setInfinite(infinite);
        configSettings.setAngleModifier(angleModifier);
        configSettings.setStrokeWidthMultiplier(strokeWidthMultiplier);
        configSettings.setLoadPointsAreVisible(loadPointsAreVisible);
        configSettings.setIndicatorAlpha(indicatorAlpha);
        return configSettings;
    }
}

