/*
 * Decompiled with CFR 0.152.
 */
package com.silverforge.controls.painters;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import com.silverforge.controls.model.ClipShape;

public class CanvasPainter {
    private Paint bigPaint;
    private Paint singlePaint;
    private Paint singlePaintTransparent;
    private Paint textPaint;

    public void initializePaints(int outerPointColor, int innerPointColor, float outerpointRadius, float innerpointRadius) {
        float strokeWidth = innerpointRadius * 6.0f;
        this.bigPaint = new Paint(1);
        this.bigPaint.setColor(outerPointColor);
        this.singlePaint = new Paint(1);
        this.singlePaint.setColor(innerPointColor);
        this.singlePaintTransparent = new Paint();
        this.singlePaintTransparent.setAntiAlias(true);
        this.singlePaintTransparent.setStyle(Paint.Style.STROKE);
        this.singlePaintTransparent.setStrokeWidth(strokeWidth);
        this.singlePaintTransparent.setColor(innerPointColor);
        this.singlePaintTransparent.setAlpha(100);
        float textSize = (float)((double)outerpointRadius * 0.4);
        this.textPaint = new Paint();
        this.textPaint.setColor(innerPointColor);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setTypeface(Typeface.MONOSPACE);
        this.textPaint.setTextSize(textSize);
    }

    public Bitmap getRoundedBitmap(Bitmap bitmap, ClipShape clipShape) {
        int zeroIntValue = 0;
        int originalWidth = bitmap.getWidth();
        int originalHeight = bitmap.getHeight();
        int posX = originalWidth / 2;
        int posY = originalHeight / 2;
        float r = originalWidth > originalHeight ? (float)(originalHeight / 2) : (float)(originalWidth / 2);
        Bitmap resultBitmap = Bitmap.createBitmap((int)originalWidth, (int)originalHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(resultBitmap);
        Paint paint = new Paint();
        Rect rect = new Rect(zeroIntValue, zeroIntValue, originalWidth, originalHeight);
        paint.setAntiAlias(true);
        canvas.drawARGB(zeroIntValue, zeroIntValue, zeroIntValue, zeroIntValue);
        switch (clipShape) {
            case ROUNDED_RECTANGLE: {
                RectF rectF = new RectF(rect);
                float cornerRadius = 32.0f;
                canvas.drawRoundRect(rectF, cornerRadius, cornerRadius, paint);
                break;
            }
            case CIRCLE: {
                canvas.drawCircle((float)posX, (float)posY, r, paint);
            }
        }
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return resultBitmap;
    }

    public Paint getBigPaint() {
        return this.bigPaint;
    }

    public Paint getSinglePaint() {
        return this.singlePaint;
    }

    public Paint getSinglePaintTransparent() {
        return this.singlePaintTransparent;
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }
}

