/*
 * Decompiled with CFR 0.152.
 */
package com.sidneysimmons.gradlepluginexternalproperties.task;

import com.sidneysimmons.gradlepluginexternalproperties.ExternalPropertiesContainer;
import com.sidneysimmons.gradlepluginexternalproperties.resolver.PropertyResolver;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public class ShowPropertyResolversTask
extends DefaultTask {
    public static final String GROUP = "External Properties";
    public static final String NAME = "showPropertyResolvers";
    public static final String DESCRIPTION = "Prints this project's configured property resolvers.";

    @TaskAction
    void action() {
        Integer resolverPosition = 1;
        Project tempProject = this.getProject();
        while (tempProject != null) {
            this.getLogger().lifecycle("Project: " + this.buildProjectHierarchyString(tempProject));
            ExternalPropertiesContainer tempContainer = (ExternalPropertiesContainer)tempProject.getExtensions().findByName("props");
            if (tempContainer != null) {
                if (!tempContainer.getResolvers().isEmpty()) {
                    for (PropertyResolver resolver : tempContainer.getResolvers()) {
                        Integer n = resolverPosition;
                        Integer n2 = resolverPosition = Integer.valueOf(resolverPosition + 1);
                        this.getLogger().lifecycle(n + ") " + resolver.toString());
                    }
                } else {
                    this.getLogger().lifecycle("No resolvers are configured.");
                }
            } else {
                this.getLogger().lifecycle("External properties container not configured.");
            }
            if ((tempProject = tempProject.getParent()) == null) continue;
            this.getLogger().lifecycle("");
        }
    }

    @Internal
    public String getGroup() {
        return GROUP;
    }

    @Internal
    public String getDescription() {
        return DESCRIPTION;
    }

    private String buildProjectHierarchyString(Project project) {
        String projectHierarchyString = null;
        for (Project tempProject = project; tempProject != null; tempProject = tempProject.getParent()) {
            projectHierarchyString = projectHierarchyString != null ? tempProject.getName() + " -> " + projectHierarchyString : tempProject.getName();
        }
        return projectHierarchyString;
    }
}

